% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/net.accessor.R
\name{net-accessor}
\alias{net-accessor}
\alias{get_attr_list}
\alias{get_attr}
\alias{add_attr}
\alias{set_attr}
\alias{append_attr}
\alias{get_epi_list}
\alias{get_epi}
\alias{add_epi}
\alias{set_epi}
\alias{get_param_list}
\alias{get_param}
\alias{add_param}
\alias{set_param}
\alias{get_control_list}
\alias{get_control}
\alias{get_network_control}
\alias{add_control}
\alias{set_control}
\alias{get_init_list}
\alias{get_init}
\alias{add_init}
\alias{set_init}
\alias{append_core_attr}
\title{Functions to Access and Edit the Main netsim_dat Object in Network Models}
\usage{
get_attr_list(dat, item = NULL)

get_attr(dat, item, posit_ids = NULL, override.null.error = FALSE)

add_attr(dat, item)

set_attr(dat, item, value, posit_ids = NULL, override.length.check = FALSE)

append_attr(dat, item, value, n.new)

get_epi_list(dat, item = NULL)

get_epi(dat, item, at = NULL, override.null.error = FALSE)

add_epi(dat, item)

set_epi(dat, item, at, value)

get_param_list(dat, item = NULL)

get_param(dat, item, override.null.error = FALSE)

add_param(dat, item)

set_param(dat, item, value)

get_control_list(dat, item = NULL)

get_control(dat, item, override.null.error = FALSE)

get_network_control(dat, network, item, override.null.error = FALSE)

add_control(dat, item)

set_control(dat, item, value)

get_init_list(dat, item = NULL)

get_init(dat, item, override.null.error = FALSE)

add_init(dat, item)

set_init(dat, item, value)

append_core_attr(dat, at, n.new)
}
\arguments{
\item{dat}{Main \code{netsim_dat} object containing a \code{networkDynamic}
object and other initialization information passed from
\code{\link{netsim}}.}

\item{item}{A character vector containing the name of the element to access
(for \code{get_} functions), create (for \code{add_} functions), or
edit (for \code{set_} and \code{append_} functions). Can be of length
> 1 for \code{get_*_list} functions.}

\item{posit_ids}{For \code{set_attr} and \code{get_attr}, a numeric vector of
posit_ids or a logical vector to subset the desired \code{item}.}

\item{override.null.error}{If TRUE, \code{get_} will return NULL if the
\code{item} does not exist instead of throwing an error.
(default = FALSE).}

\item{value}{New value to be attributed in the \code{set_} and \code{append_}
functions.}

\item{override.length.check}{If TRUE, \code{set_attr} allows the modification
of the \code{item} size. (default = FALSE).}

\item{n.new}{For \code{append_core_attr}, the number of new nodes to initiate
with core attributes; for \code{append_attr}, the number of new
elements to append at the end of \code{item}.}

\item{at}{For \code{get_epi}, the timestep at which to access the specified
\code{item}; for \code{set_epi}, the timestep at which to add the new
value for the epi output \code{item}; for \code{append_core_attr}, the
current time step.}

\item{network}{index of network for which to get control}
}
\value{
A vector or a list of vectors for \code{get_} functions; the main
list object for \code{set_}, \code{append_}, and \code{add_}
functions.
}
\description{
These \code{get_}, \code{set_}, \code{append_}, and \code{add_}
functions allow a safe and efficient way to retrieve and mutate
the main \code{netsim_dat} class object of network models
(typical variable name \code{dat}).
}
\section{Core Attribute}{

The \code{append_core_attr} function initializes the attributes necessary for
EpiModel to work (the four core attributes are: "active", "unique_id",
"entrTime", and "exitTime"). These attributes are used in the initialization
phase of the simulation, to create the nodes (see
\code{\link{initialize.net}}); and also used when adding nodes during the
simulation (see \code{\link{arrivals.net}}).
}

\section{Mutability}{

The \code{set_}, \code{append_}, and \code{add_} functions DO NOT modify the
\code{netsim_dat} object in place. The result must be assigned back to
\code{dat} in order to be registered: \code{dat <- set_*(dat, item, value)}.
}

\section{\code{set_} and \code{append_} vs \code{add_}}{

The \code{set_} and \code{append_} functions edit a pre-existing element or
create a new one if it does not exist already by calling the \code{add_}
functions internally.
}

\examples{
dat <- list(
  attr = list(
    active = rbinom(100, 1, 0.9)
  ),
  epi = list(),
  param = list(),
  init = list(),
  control = list(
    nsteps = 150
  )
)
class(dat) <- c("netsim_dat", class(dat))

dat <- add_attr(dat, "age")
dat <- set_attr(dat, "age", runif(100))
dat <- set_attr(dat, "status", rbinom(100, 1, 0.9))
dat <- set_attr(dat, "status", rep(1, 150), override.length.check = TRUE)
dat <- append_attr(dat, "status", 1, 10)
dat <- append_attr(dat, "age", NA, 10)
get_attr_list(dat)
get_attr_list(dat, c("age", "active"))
get_attr(dat, "status")
get_attr(dat, "status", c(1, 4))

dat <- add_epi(dat, "i.num")
dat <- set_epi(dat, "i.num", 150, 10)
dat <- set_epi(dat, "s.num", 150, 90)
get_epi_list(dat)
get_epi_list(dat, c("i.num", "s.num"))
get_epi(dat, "i.num")
get_epi(dat, "i.num", c(1, 4))
get_epi(dat, "i.num", rbinom(150, 1, 0.2) == 1)

dat <- add_param(dat, "x")
dat <- set_param(dat, "x", 0.4)
dat <- set_param(dat, "y", 0.8)
get_param_list(dat)
get_param_list(dat, c("x", "y"))
get_param(dat, "x")

dat <- add_init(dat, "x")
dat <- set_init(dat, "x", 0.4)
dat <- set_init(dat, "y", 0.8)
get_init_list(dat)
get_init_list(dat, c("x", "y"))
get_init(dat, "x")

dat <- add_control(dat, "x")
dat <- set_control(dat, "x", 0.4)
dat <- set_control(dat, "y", 0.8)
get_control_list(dat)
get_control_list(dat, c("x", "y"))
get_control(dat, "x")

}
