% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.data.frame.R
\name{as.data.frame.icm}
\alias{as.data.frame.icm}
\alias{as.data.frame.netsim}
\title{Extract Model Data for Stochastic Models}
\usage{
\method{as.data.frame}{icm}(
  x,
  row.names = NULL,
  optional = FALSE,
  out = "vals",
  sim,
  qval,
  ...
)

\method{as.data.frame}{netsim}(x, row.names = NULL, optional = FALSE, out = "vals", sim, ...)
}
\arguments{
\item{x}{An \code{EpiModel} object of class \code{icm} or \code{netsim}.}

\item{row.names}{See \code{\link{as.data.frame.default}}.}

\item{optional}{See \code{\link{as.data.frame.default}}.}

\item{out}{Data output to data frame: \code{"mean"} for row means across
simulations, \code{"sd"} for row standard deviations across
simulations, \code{"qnt"} for row quantiles at the level specified in
\code{qval}, or \code{"vals"} for values from individual simulations.}

\item{sim}{If \code{out="vals"}, the simulation number to output. If not
specified, then data from all simulations will be output.}

\item{qval}{Quantile value required when \code{out="qnt"}.}

\item{...}{See \code{\link{as.data.frame.default}}.}
}
\value{
A data frame containing the data from \code{x}.
}
\description{
This function extracts model simulations for objects of classes
             \code{icm} and \code{netsim} into a data frame using
             the generic \code{as.data.frame} function.
}
\details{
These methods work for both \code{icm} and \code{netsim} class models. The
available output includes time-specific means, standard deviations,
quantiles, and simulation values (compartment and flow sizes) from these
stochastic model classes. Means, standard deviations, and quantiles are
calculated by taking the row summary (i.e., each row of data is corresponds
to a time step) across all simulations in the model output.
}
\examples{
## Stochastic ICM SIS model
param <- param.icm(inf.prob = 0.8, act.rate = 2, rec.rate = 0.1)
init <- init.icm(s.num = 500, i.num = 1)
control <- control.icm(type = "SIS", nsteps = 10,
                       nsims = 3, verbose = FALSE)
mod <- icm(param, init, control)

# Default output all simulation runs, default to all in stacked data.frame
as.data.frame(mod)
as.data.frame(mod, sim = 2)

# Time-specific means across simulations
as.data.frame(mod, out = "mean")

# Time-specific standard deviations across simulations
as.data.frame(mod, out = "sd")

# Time-specific quantile values across simulations
as.data.frame(mod, out = "qnt", qval = 0.25)
as.data.frame(mod, out = "qnt", qval = 0.75)

\dontrun{
## Stochastic SI Network Model
nw <- network_initialize(n = 100)
formation <- ~edges
target.stats <- 50
coef.diss <- dissolution_coefs(dissolution = ~offset(edges), duration = 20)
est <- netest(nw, formation, target.stats, coef.diss, verbose = FALSE)

param <- param.net(inf.prob = 0.5)
init <- init.net(i.num = 10)
control <- control.net(type = "SI", nsteps = 10, nsims = 3, verbose = FALSE)
mod <- netsim(est, param, init, control)

# Same data extraction methods as with ICMs
as.data.frame(mod)
as.data.frame(mod, sim = 2)
as.data.frame(mod, out = "mean")
as.data.frame(mod, out = "sd")
as.data.frame(mod, out = "qnt", qval = 0.25)
as.data.frame(mod, out = "qnt", qval = 0.75)
}

}
\keyword{extract}
