% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ErgmTerms.R
\name{InitErgmTerm.fuzzynodematch}
\alias{InitErgmTerm.fuzzynodematch}
\alias{fuzzynodematch}
\title{Definition for fuzzynodematch ERGM Term}
\usage{
InitErgmTerm.fuzzynodematch(nw, arglist, ...)
}
\arguments{
\item{nw}{An object of class \code{network}.}

\item{arglist}{A list of arguments as specified in the \code{ergm.userterms}
package framework.}

\item{...}{Additional data passed into the function as specified in the
\code{ergm.userterms} package framework.}
}
\description{
This function defines and initializes the fuzzynodematch ERGM
             term that allows for generalized homophily.
}
\details{
This ERGM user term was written to allow for generalized homophily.The
\code{attr} term argument should specify a character vertex attribute
encoding the "venues" associated to each node.  The \code{split} argument
should specify a string that separates different "venues" in the attribute
value for each node, as handled by \code{strsplit} with \code{fixed = TRUE}.
For example, if \code{split} is \code{"|"} (the default), and the attribute
value for a given node is \code{"a12|b476"}, then the associated venues for
this node are \code{"a12"} and \code{"b476"}.  The empty string \code{""} is
interpreted as "no venues".

If the \code{binary} term argument is \code{FALSE} (the default), the change
statistic for an on-toggle is the number of unique venues associated to both
nodes (informally speaking, this could be described as the number of venues
on which the two nodes "match"); if \code{binary} is \code{TRUE}, the change
statistic for an on-toggle is \code{1} if any venue is associated to both
nodes, and \code{0} otherwise.
}
