% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compatibility.R
\name{EstimateR}
\alias{EstimateR}
\title{Function to ensure compatibility with EpiEstim versions <2.0}
\usage{
EstimateR(I, T.Start, T.End, method = c("NonParametricSI",
  "ParametricSI", "UncertainSI"), n1 = NULL, n2 = NULL,
  Mean.SI = NULL, Std.SI = NULL, Std.Mean.SI = NULL,
  Min.Mean.SI = NULL, Max.Mean.SI = NULL, Std.Std.SI = NULL,
  Min.Std.SI = NULL, Max.Std.SI = NULL, SI.Distr = NULL,
  Mean.Prior = 5, Std.Prior = 5, CV.Posterior = 0.3, plot = FALSE,
  leg.pos = "topright")
}
\arguments{
\item{I}{see \code{incid} in \code{estimate_R}}

\item{T.Start}{see \code{config$t_start} in \code{estimate_R}}

\item{T.End}{see \code{config$t_end} in \code{estimate_R}}

\item{method}{see method in \code{estimate_R} (but EstimateR uses CamelCase 
where estimate_R uses snake_case for the method names)}

\item{n1}{see \code{n1} in \code{estimate_R}}

\item{n2}{see \code{n2} in \code{estimate_R}}

\item{Mean.SI}{see \code{config$mean_si} in \code{estimate_R}}

\item{Std.SI}{see \code{config$std_si} in \code{estimate_R}}

\item{Std.Mean.SI}{see \code{config$std_mean_si} in \code{estimate_R}}

\item{Min.Mean.SI}{see \code{config$min_mean_si} in \code{estimate_R}}

\item{Max.Mean.SI}{see \code{config$max_mean_si} in \code{estimate_R}}

\item{Std.Std.SI}{see \code{config$std_std_si} in \code{estimate_R}}

\item{Min.Std.SI}{see \code{config$min_std_si} in \code{estimate_R}}

\item{Max.Std.SI}{see \code{config$max_std_si} in \code{estimate_R}}

\item{SI.Distr}{see \code{config$si_distr} in \code{estimate_R}}

\item{Mean.Prior}{see \code{config$mean_prior} in \code{estimate_R}}

\item{Std.Prior}{see \code{config$std_prior} in \code{estimate_R}}

\item{CV.Posterior}{see \code{config$cv_posterior} in \code{estimate_R}}

\item{plot}{Not used anymore, only there for compatibility}

\item{leg.pos}{Not used anymore, only there for compatibility}
}
\description{
Please only use for compatibility;
Prefer the new estimate_R function instead
}
