\name{SIRSinusoidalBirth}
\alias{SIRSinusoidalBirth}
\title{SIR model with sinusoidal births (P 5.3).}
\usage{
SIRSinusoidalBirth(pars = NULL, init = NULL, time = NULL, ...)
}
\arguments{
  \item{pars}{\code{\link{list}} with: the transmission
  rate, the mean birth rate, a scalar (or a
  \code{\link{vector}} to create bifurcations) with the
  amplitude of sinuoidal forcing for the birth rate, the
  frequency of the oscillations, the per capita death rate
  and the recovery rate. The names of these values must be
  "beta", "alpha0", "alpha1", "w", "mu" and "gamma",
  respectively. All rates must be specified in days and
  alpha1 <= 1.}

  \item{init}{\code{\link{vector}} with 3 values: the
  initial proportion of susceptibles and infectious. The
  names of these values must be "S" and "I", respectively.
  All parameters must be positive and S + I <= 1.}

  \item{time}{time sequence for which output is wanted; the
  first value of times must be the initial time.}

  \item{...}{further arguments passed to
  \link[deSolve]{ode} function.}
}
\value{
\code{\link{list}}. The first element, \code{*$model}, is
the model function. The second element is a
\code{\link{list}} with the the \code{*$pars} argument. The
third and fourth elements are the vectors (\code{*$init},
\code{*$time}, containing the \code{init} and \code{time}
arguments of the function. The fifth element
\code{*$results} is a \code{\link{data.frame}} with up to
as many rows as elements in time. First column contains the
time. Second, third and fourth columns contain the
proportion of susceptibles, infectious and recovered.
}
\description{
Solves a SIR model with sinusoidal forcing of the birth
rate.
}
\details{
This is the R version of program 5.3 from page 184 of
"Modeling Infectious Disease in humans and animals" by
Keeling & Rohani. To create bifurcations, \code{alpha1}
must be a vector. For bifurcations, if max(time) < 3650),
time is defined as c(0:3650).
}
\examples{
# Parameters and initial conditions (bifurcation plot of infectious)
parameters <- list(beta = 17 / 13, alpha0 = 1 / (50 * 365),
                   alpha1 = 0.25, w = 2 * pi / 365 ,
                   mu = 1 / (50 * 365), gamma =  1 / 13)

parameters2 <- list(beta = 17 / 13, alpha0 = 1 / (50 * 365),
                   alpha1 = seq(0, 0.99, 0.01), w = 2 * pi / 365 ,
                   mu = 1 / (50 * 365), gamma =  1 / 13)

initials <- c(S = 1 / 17, I = 1e-4, R =  1 - (1 / 17 + 1e-4))

# Solve the system.
sir.sinusoidal.birth <- SIRSinusoidalBirth(pars = parameters,
                                           init = initials,
                                           time = 0:(20 * 365))

# Bifurcations
# Uncomment the following lines:
# bifurcation <- SIRSinusoidalBirth(pars = parameters2,
#                                   init = initials,
#                                   time = 0:(20 * 365))
}
\references{
Keeling, Matt J., and Pejman Rohani. Modeling infectious
diseases in humans and animals. Princeton University Press,
2008.
\href{http://www.modelinginfectiousdiseases.org/}{Modeling
Infectious Diseases in Humans and Animals}. It is important
to note that we wrote equations for the R population based
on equations in the website and because of the dynamic S +
I + R fluctuates around 1. Then, using R = 1 - S - I solves
this inconsistency.
}
\seealso{
\link[deSolve]{ode}.
}

