% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_docu.R
\docType{data}
\name{election}
\alias{election}
\title{Election Data}
\format{A data frame with 816 observations on the following 30 variables.
\describe{ \item{Age}{Standardized age of the voter}
\item{AgeOrig}{Unstandardized age of the voter}
\item{Partychoice}{Party Choice with levels \code{CDU}, \code{SPD},
\code{FDP}, \code{Greens} and \code{Left Party}}
\item{Gender}{Gender with levels \code{female} and \code{male}}
\item{West}{Regional provenance (West-Germany or East-Germany) with
levels \code{east} and \code{west}} \item{Union}{Member of a Union
with levels \code{no member} and \code{member}}
\item{Highschool}{Educational level with levels \code{no highschool}
and \code{highschool}} \item{Unemployment}{Unemployment with levels
\code{not unemployed} and \code{unemployed}}
\item{Pol.Interest}{Political Interest with levels \code{very
interested} and \code{less interested}}
\item{Democracy}{Satisfaction with the functioning of democracy with
levels \code{satisfied} and \code{not satisfied}}
\item{Religion}{Religion with levels \code{evangelical},
\code{catholic} and \code{other religion}}
\item{Social_CDU}{Difference in attitude towards the socioeconomic
dimension of politics between respondent and CDU}
\item{Social_SPD}{Difference in attitude towards the socioeconomic
dimension of politics between respondent and SPD}
\item{Social_FDP}{Difference in attitude towards the socioeconomic
dimension of politics between respondent and FDP}
\item{Social_Greens}{Difference in attitude towards the
socioeconomic dimension of politics between respondent and the Greens}
\item{Social_Left}{Difference in attitude towards the socioeconomic
dimension of politics between respondent and the Left party}
\item{Immigration_CDU}{Difference in attitude towards immigration of
foreigners between respondent and CDU}
\item{Immigration_SPD}{Difference in attitude towards immigration of
foreigners between respondent and SPD}
\item{Immigration_FDP}{Difference in attitude towards immigration of
foreigners between respondent and FDP}
\item{Immigration_Greens}{Difference in attitude towards immigration
of foreigners between respondent and the Greens}
\item{Immigration_Left}{Difference in attitude towards immigration
of foreigners between respondent and the Left party}
\item{Nuclear_CDU}{Difference in attitude towards nuclear energy
between respondent and CDU} \item{Nuclear_SPD}{Difference in
attitude towards nuclear energy between respondent and SPD}
\item{Nuclear_FDP}{Difference in attitude towards nuclear energy
between respondent and FDP} \item{Nuclear_Greens}{Difference in
attitude towards nuclear energy between respondent and the Greens}
\item{Nuclear_Left}{Difference in attitude towards nuclear energy
between respondent and the Left party}
\item{Left_Right_CDU}{Difference in attitude towards the positioning
on a political left-right scale between respondent and CDU}
\item{Left_Right_SPD}{Difference in attitude towards the positioning
on a political left-right scale between respondent and SPD}
\item{Left_Right_FDP}{Difference in attitude towards the positioning
on a political left-right scale between respondent and FDP}
\item{Left_Right_Greens}{Difference in attitude towards the
positioning on a political left-right scale between respondent and the
Greens} \item{Left_Right_Left}{Difference in attitude towards the
positioning on a political left-right scale between respondent and the Left
party} }}
\description{
The data set contains data from the German Longitudinal Election Study. The
Response Categories refer to the five dominant parties in Germany. The
explanatory variables refer to the declarations of single voters.
}
\examples{

data(election)
vignette("election")

}
\references{
German Longitudinal Election Study (GLES)
}
\keyword{datasets}
\keyword{multinomial}
\keyword{response}

