% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/effectliter.R
\name{conditionalEffectsPlot}
\alias{conditionalEffectsPlot}
\title{Plot conditional effects}
\usage{
conditionalEffectsPlot(obj, zsel, gxsel = "g1", colour = "")
}
\arguments{
\item{obj}{Object of class \code{effectlite} obtained from fitting an effect
model using \code{\link[EffectLiteR]{effectLite}}}

\item{zsel}{Name of a covariate (character string) plotted on the x-axis.}

\item{gxsel}{Name of an effect function (character string) plotted on the y-axis.}

\item{colour}{Name of a covariate (character string) used as colour variable
in the plot.}
}
\value{
Object of class \code{c("gg", "ggplot")}.
}
\description{
Can be used to make a conditional effects plot with an effect function on the
y axis and a covariate on the x axis. \code{ggplot2} is used to create the plot.
}
\examples{
m1 <- effectLite(y="dv", x="x", k="k1", z="z1", control="control", data=example01)
conditionalEffectsPlot(m1, zsel="z1", gxsel="g1", colour="k1")
}

