sdfaREF <- c(
  "invalid", "invalid", "invalid", "invalid", "invalid", "Male",
  "Female", "Female", "Male", "Female", "other invalid", "other invalid",
  "other invalid", "other invalid", "other invalid", "Male", "Male",
  "Male", "Male", "Male"
)
es1REF <- c(
  "",
  "Formula: composite ~ dsex + b017451 ",
  "",
  "Plausible values: 5",
  "jrrIMax: 1",
  "Weight variable: 'origwt'",
  "Variance method: jackknife",
  "JK replicates: 62",
  "full data n: 17606",
  "n used: 16331",
  "",
  "",
  "Summary Table:",
  "   dsex              b017451    N    WTD_N      PCT   SE(PCT)     MEAN SE(MEAN)",
  "   Male Never or hardly ever 2350 2434.844 29.00978 0.6959418 270.8243 1.057078",
  "   Male Once every few weeks 1603 1638.745 19.52472 0.5020657 275.0807 1.305922",
  "   Male    About once a week 1384 1423.312 16.95795 0.5057265 281.5612 1.409587",
  "   Male  2 or 3 times a week 1535 1563.393 18.62694 0.4811497 284.9066 1.546072",
  "   Male            Every day 1291 1332.890 15.88062 0.5872731 277.2597 1.795784",
  " Female Never or hardly ever 1487 1517.609 18.20203 0.5078805 266.7897 1.519020",
  " Female Once every few weeks 1544 1552.149 18.61630 0.4892491 271.2255 1.205528",
  " Female    About once a week 1469 1514.403 18.16358 0.5782966 278.7502 1.719778",
  " Female  2 or 3 times a week 1827 1862.502 22.33864 0.4844840 282.7765 1.404107",
  " Female            Every day 1841 1890.918 22.67945 0.6553039 275.4628 1.219439"
)
es2REF <- c(
  "",
  "Formula: composite ~ dsex + b017451 ",
  "",
  "Plausible values: 5",
  "jrrIMax: 5",
  "Weight variable: 'origwt'",
  "Variance method: jackknife",
  "JK replicates: 62",
  "full data n: 17606",
  "n used: 8163",
  "",
  "",
  "Summary Table:",
  " dsex              b017451    N    WTD_N      PCT   SE(PCT)     MEAN SE(MEAN)",
  " Male Never or hardly ever 2350 2434.844 29.00978 0.6959418 270.8243 1.063871",
  " Male Once every few weeks 1603 1638.745 19.52472 0.5020657 275.0807 1.364160",
  " Male    About once a week 1384 1423.312 16.95795 0.5057265 281.5612 1.418074",
  " Male  2 or 3 times a week 1535 1563.393 18.62694 0.4811497 284.9066 1.516851",
  " Male            Every day 1291 1332.890 15.88062 0.5872731 277.2597 1.787613"
)
es2bREF <- c(
  "",
  "Formula: composite ~ dsex + b017451 ",
  "",
  "Plausible values: 5",
  "jrrIMax: 1",
  "Weight variable: 'origwt'",
  "Variance method: jackknife",
  "JK replicates: 62",
  "full data n: 17606",
  "n used: 8486",
  "",
  "",
  "Summary Table:",
  " dsex              b017451    N     WTD_N         PCT    SE(PCT)     MEAN  SE(MEAN)",
  " Male Never or hardly ever 2350 2434.8441 28.60492810 0.68430755 270.8243  1.057078",
  " Male Once every few weeks 1603 1638.7454 19.25223646 0.49453557 275.0807  1.305922",
  " Male    About once a week 1384 1423.3119 16.72129011 0.50183066 281.5612  1.409587",
  " Male  2 or 3 times a week 1535 1563.3931 18.36698589 0.47896939 284.9066  1.546072",
  " Male            Every day 1291 1332.8898 15.65899718 0.57813910 277.2597  1.795784",
  " Male              Omitted  316  111.8050  1.31350257 0.14918974 247.3158  3.153504",
  " Male             Multiple    7    6.9849  0.08205969 0.03808503 269.6227 14.332979"
)
es3REF <- c(
  "",
  "Formula: composite ~ lep + ell3 ",
  "",
  "Plausible values: 5",
  "jrrIMax: 1",
  "Weight variable: 'origwt'",
  "Variance method: jackknife",
  "JK replicates: 62",
  "full data n: 17606",
  "n used: 16910",
  "",
  "",
  "Summary Table:",
  " lep         ell3     N      WTD_N       PCT   SE(PCT)     MEAN SE(MEAN)",
  " Yes          Yes   974  1174.6779 100.00000 0.0000000 242.6400 2.532236",
  " Yes           No     0     0.0000   0.00000        NA       NA       NA",
  " Yes Formerly ELL     0     0.0000   0.00000        NA       NA       NA",
  "  No          Yes     0     0.0000   0.00000        NA       NA       NA",
  "  No           No 15670 15409.5372  97.80187 0.4011031 278.4854 0.804167",
  "  No Formerly ELL   266   346.3346   2.19813 0.4011031 273.1676 2.594586"
)
es4REF <- c(
  "",
  "Formula: composite ~ lep + ell3 + dsex ",
  "",
  "Plausible values: 5",
  "jrrIMax: 1",
  "Weight variable: 'origwt'",
  "Variance method: jackknife",
  "JK replicates: 62",
  "full data n: 17606",
  "n used: 16910",
  "",
  "",
  "Summary Table:",
  " lep         ell3   dsex    N     WTD_N      PCT   SE(PCT)     MEAN  SE(MEAN)",
  " Yes          Yes   Male  523  625.3030 53.23187 2.0754188 245.5156 3.0412906",
  " Yes          Yes Female  451  549.3749 46.76813 2.0754188 239.3670 2.6004242",
  " Yes           No   Male    0    0.0000       NA        NA       NA        NA",
  " Yes           No Female    0    0.0000       NA        NA       NA        NA",
  " Yes Formerly ELL   Male    0    0.0000       NA        NA       NA        NA",
  " Yes Formerly ELL Female    0    0.0000       NA        NA       NA        NA",
  "  No          Yes   Male    0    0.0000       NA        NA       NA        NA",
  "  No          Yes Female    0    0.0000       NA        NA       NA        NA",
  "  No           No   Male 7828 7723.4302 50.12110 0.5013799 279.2644 0.8048072",
  "  No           No Female 7842 7686.1070 49.87890 0.5013799 277.7026 0.9301768",
  "  No Formerly ELL   Male  131  161.4708 46.62277 5.1070256 276.0706 3.2811027",
  "  No Formerly ELL Female  135  184.8638 53.37723 5.1070256 270.6318 2.9073272"
)
es11REF1 <- c(
  "",
  "Formula: b017451 ~ dsex ",
  "",
  "Weight variable: 'origwt'",
  "Variance method: jackknife",
  "JK replicates: 62",
  "full data n: 17606",
  "n used: 16331",
  "",
  "",
  "Summary Table:",
  "   dsex    N    WTD_N      PCT   SE(PCT)     MEAN   SE(MEAN)",
  "   Male 8163 8393.184 50.16617 0.5101521 2.728439 0.02403706",
  " Female 8168 8337.580 49.83383 0.5101521 3.126772 0.01859650"
)
es1rREF <- c(
  "",
  "Formula: composite ~ dsex + b017451 ",
  "",
  "Plausible values: 5",
  "jrrIMax: 1",
  "Weight variable: 'origwt'",
  "Variance method: jackknife",
  "JK replicates: 62",
  "full data n: 17606",
  "n used: 16331",
  "",
  "",
  "Summary Table:",
  "   dsex              b017451    N    WTD_N      PCT   SE(PCT)     MEAN SE(MEAN)",
  " Female Never or hardly ever 1487 1517.609 18.20203 0.5078805 266.7897 1.519020",
  " Female Once every few weeks 1544 1552.149 18.61630 0.4892491 271.2255 1.205528",
  " Female    About once a week 1469 1514.403 18.16358 0.5782966 278.7502 1.719778",
  " Female  2 or 3 times a week 1827 1862.502 22.33864 0.4844840 282.7765 1.404107",
  " Female            Every day 1841 1890.918 22.67945 0.6553039 275.4628 1.219439",
  "   MALE Never or hardly ever 2350 2434.844 29.00978 0.6959418 270.8243 1.057078",
  "   MALE Once every few weeks 1603 1638.745 19.52472 0.5020657 275.0807 1.305922",
  "   MALE    About once a week 1384 1423.312 16.95795 0.5057265 281.5612 1.409587",
  "   MALE  2 or 3 times a week 1535 1563.393 18.62694 0.4811497 284.9066 1.546072",
  "   MALE            Every day 1291 1332.890 15.88062 0.5872731 277.2597 1.795784"
)
es1tREF <- c(
  "",
  "Formula: composite ~ dsex + b017451 ",
  "",
  "Plausible values: 5",
  "Weight variable: 'origwt'",
  "Variance method: Taylor series",
  "full data n: 17606",
  "n used: 16331",
  "",
  "",
  "Summary Table:",
  "   dsex              b017451    N    WTD_N      PCT   SE(PCT)     MEAN SE(MEAN)",
  "   Male Never or hardly ever 2350 2434.844 29.00978 0.6968466 270.8243 1.064411",
  "   Male Once every few weeks 1603 1638.745 19.52472 0.5017827 275.0807 1.363576",
  "   Male    About once a week 1384 1423.312 16.95795 0.5060344 281.5612 1.417767",
  "   Male  2 or 3 times a week 1535 1563.393 18.62694 0.4810093 284.9066 1.513590",
  "   Male            Every day 1291 1332.890 15.88062 0.5866306 277.2597 1.789257",
  " Female Never or hardly ever 1487 1517.609 18.20203 0.5079071 266.7897 1.535320",
  " Female Once every few weeks 1544 1552.149 18.61630 0.4889362 271.2255 1.208797",
  " Female    About once a week 1469 1514.403 18.16358 0.5787277 278.7502 1.739417",
  " Female  2 or 3 times a week 1827 1862.502 22.33864 0.4846566 282.7765 1.386048",
  " Female            Every day 1841 1890.918 22.67945 0.6554100 275.4628 1.242831"
)
es3tREF <- c(
  "",
  "Formula: composite ~ lep + ell3 ",
  "",
  "Plausible values: 5",
  "Weight variable: 'origwt'",
  "Variance method: Taylor series",
  "full data n: 17606",
  "n used: 16910",
  "",
  "",
  "Summary Table:",
  " lep         ell3     N      WTD_N       PCT   SE(PCT)     MEAN SE(MEAN)",
  " Yes          Yes   974  1174.6779 100.00000 0.0000000 242.6400 2.486567",
  " Yes           No     0     0.0000   0.00000        NA       NA       NA",
  " Yes Formerly ELL     0     0.0000   0.00000        NA       NA       NA",
  "  No          Yes     0     0.0000   0.00000        NA       NA       NA",
  "  No           No 15670 15409.5372  97.80187 0.4014304 278.4854 0.797255",
  "  No Formerly ELL   266   346.3346   2.19813 0.4014304 273.1676 2.045678"
)
es4tREF <- c(
  "",
  "Formula: composite ~ lep + ell3 + dsex ",
  "",
  "Plausible values: 5",
  "Weight variable: 'origwt'",
  "Variance method: Taylor series",
  "full data n: 17606",
  "n used: 16910",
  "",
  "",
  "Summary Table:",
  " lep         ell3   dsex    N     WTD_N      PCT   SE(PCT)     MEAN  SE(MEAN)",
  " Yes          Yes   Male  523  625.3030 53.23187 1.9890178 245.5156 3.0903652",
  " Yes          Yes Female  451  549.3749 46.76813 1.9890178 239.3670 2.4980995",
  " Yes           No   Male    0    0.0000       NA        NA       NA        NA",
  " Yes           No Female    0    0.0000       NA        NA       NA        NA",
  " Yes Formerly ELL   Male    0    0.0000       NA        NA       NA        NA",
  " Yes Formerly ELL Female    0    0.0000       NA        NA       NA        NA",
  "  No          Yes   Male    0    0.0000       NA        NA       NA        NA",
  "  No          Yes Female    0    0.0000       NA        NA       NA        NA",
  "  No           No   Male 7828 7723.4302 50.12110 0.5018499 279.2644 0.8304033",
  "  No           No Female 7842 7686.1070 49.87890 0.5018499 277.7026 0.8980066",
  "  No Formerly ELL   Male  131  161.4708 46.62277 3.2749498 276.0706 2.2525511",
  "  No Formerly ELL Female  135  184.8638 53.37723 3.2749498 270.6318 2.1989056"
)
es2tREF <- c(
  "",
  "Formula: composite ~ dsex + b017451 ",
  "",
  "Plausible values: 5",
  "Weight variable: 'origwt'",
  "Variance method: Taylor series",
  "full data n: 17606",
  "n used: 8163",
  "",
  "",
  "Summary Table:",
  " dsex              b017451    N    WTD_N      PCT   SE(PCT)     MEAN SE(MEAN)",
  " Male Never or hardly ever 2350 2434.844 29.00978 0.6968466 270.8243 1.064411",
  " Male Once every few weeks 1603 1638.745 19.52472 0.5017827 275.0807 1.363576",
  " Male    About once a week 1384 1423.312 16.95795 0.5060344 281.5612 1.417767",
  " Male  2 or 3 times a week 1535 1563.393 18.62694 0.4810093 284.9066 1.513590",
  " Male            Every day 1291 1332.890 15.88062 0.5866306 277.2597 1.789257"
)
es5REF <- c(
  "",
  "Formula: composite ~ dsex + b017451 + b003501 ",
  "",
  "Plausible values: 5",
  "jrrIMax: 1",
  "Weight variable: 'origwt'",
  "Variance method: jackknife",
  "JK replicates: 62",
  "full data n: 17606",
  "n used: 11220",
  "",
  "",
  "Summary Table:",
  "   dsex              b017451             b003501   N    WTD_N          PCT     SE(PCT)     MEAN  SE(MEAN)",
  "   Male Never or hardly ever Did not finish H.S. 272 310.8802  17.72940063  1.14024611 263.9155  2.991726",
  "   Male Never or hardly ever      Graduated H.S. 537 578.2229  32.97587125  1.88469879 267.4535  1.843952",
  "   Male Never or hardly ever  Some ed after H.S. 331 317.7697  18.12230667  1.24832679 280.4252  2.261628",
  "   Male Never or hardly ever        I Don't Know 532 529.9507  30.22292277  1.56536824 261.6397  2.040295",
  "   Male Never or hardly ever             Omitted  12  11.2908   0.64391079  0.25022633 268.9041 14.753081",
  "   Male Never or hardly ever            Multiple   8   5.3584   0.30558788  0.12404461 240.3699  9.304228",
  "   Male Once every few weeks Did not finish H.S. 146 163.2387  14.85354708  1.61622652 259.5417  3.630696",
  "   Male Once every few weeks      Graduated H.S. 346 330.9260  30.11188475  1.87614642 272.5339  2.588797",
  "   Male Once every few weeks  Some ed after H.S. 278 283.3226  25.78031789  1.75745099 281.7856  2.809875",
  "   Male Once every few weeks        I Don't Know 281 304.8037  27.73494342  1.71243269 258.8692  3.517282",
  "   Male Once every few weeks             Omitted  12  15.7402   1.43224494  0.60410794 263.9764 15.310143",
  "   Male Once every few weeks            Multiple   2   0.9568   0.08706192  0.07535344 280.4576 45.423116",
  "   Male    About once a week Did not finish H.S. 121 135.6330  15.58203525  1.88294733 267.6255  3.998351",
  "   Male    About once a week      Graduated H.S. 280 271.1711  31.15316803  1.88183648 274.2035  2.677930",
  "   Male    About once a week  Some ed after H.S. 260 258.4927  29.69662518  2.22119486 283.3629  2.935690",
  "   Male    About once a week        I Don't Know 177 198.9762  22.85914315  1.82072979 271.2701  2.870066",
  "   Male    About once a week             Omitted   6   4.1145   0.47268942  0.29109262 269.7929 20.076189",
  "   Male    About once a week            Multiple   2   2.0572   0.23633897  0.17157444 236.3750 12.703270",
  "   Male  2 or 3 times a week Did not finish H.S.  89  96.6894  10.44282542  1.52159467 266.8165  4.107300",
  "   Male  2 or 3 times a week      Graduated H.S. 293 306.6696  33.12149102  2.41121904 275.9671  2.477269",
  "   Male  2 or 3 times a week  Some ed after H.S. 289 303.0328  32.72870270  2.18848867 286.4461  2.983216",
  "   Male  2 or 3 times a week        I Don't Know 193 210.3634  22.72005267  1.86922563 264.9552  3.162175",
  "   Male  2 or 3 times a week             Omitted   9   8.7073   0.94042174  0.38952042 283.6697 24.843980",
  "   Male  2 or 3 times a week            Multiple   1   0.4306   0.04650645  0.04655901 248.7740        NA",
  "   Male            Every day Did not finish H.S.  90  85.7821  11.36255833  1.64520050 257.4599  5.883638",
  "   Male            Every day      Graduated H.S. 215 213.8557  28.32698041  1.95061779 273.4292  3.602727",
  "   Male            Every day  Some ed after H.S. 229 227.9686  30.19635233  2.14371557 283.3870  3.215319",
  "   Male            Every day        I Don't Know 172 216.3440  28.65657661  1.98956599 251.6449  3.370548",
  "   Male            Every day             Omitted   8   7.2720   0.96323737  0.44820372 262.7851 14.299386",
  "   Male            Every day            Multiple   5   3.7317   0.49429495  0.36912334 257.0412  8.431290",
  "   Male              Omitted Did not finish H.S.   4   3.3967   3.12085396  1.68883400 234.8160 28.218381",
  "   Male              Omitted      Graduated H.S.   9   7.1764   6.59360449  2.79795593 247.5784 10.179278",
  "   Male              Omitted  Some ed after H.S.   4   1.7702   1.62644204  1.07306114 261.6516 11.101459",
  "   Male              Omitted        I Don't Know   6   6.9372   6.37382992  3.46135576 236.1812 24.900647",
  "   Male              Omitted             Omitted 291  89.5583  82.28526959  4.00340538 249.1822  3.833965",
  "   Male              Omitted            Multiple   0   0.0000   0.00000000          NA       NA        NA",
  "   Male             Multiple Did not finish H.S.   0   0.0000   0.00000000          NA       NA        NA",
  "   Male             Multiple      Graduated H.S.   0   0.0000   0.00000000          NA       NA        NA",
  "   Male             Multiple  Some ed after H.S.   3   1.5787  39.28384801 21.17715124 300.7674 10.920051",
  "   Male             Multiple        I Don't Know   0   0.0000   0.00000000          NA       NA        NA",
  "   Male             Multiple             Omitted   1   2.4400  60.71615199 21.17715124 239.0700        NA",
  "   Male             Multiple            Multiple   0   0.0000   0.00000000          NA       NA        NA",
  " Female Never or hardly ever Did not finish H.S. 257 265.8121  22.66087809  1.83211169 257.9069  2.866308",
  " Female Never or hardly ever      Graduated H.S. 370 393.8865  33.57941176  2.35231946 266.8433  2.494888",
  " Female Never or hardly ever  Some ed after H.S. 194 198.6895  16.93857630  1.10226541 276.9228  3.159055",
  " Female Never or hardly ever        I Don't Know 287 308.6794  26.31537937  1.83786094 255.5826  2.689146",
  " Female Never or hardly ever             Omitted   5   5.2627   0.44865303  0.26376131 304.8005 19.068264",
  " Female Never or hardly ever            Multiple   1   0.6698   0.05710145  0.05715608 243.7680        NA",
  " Female Once every few weeks Did not finish H.S. 192 201.7517  17.95235277  1.22332270 263.7769  3.318216",
  " Female Once every few weeks      Graduated H.S. 380 393.1678  34.98501892  1.82186485 267.4015  2.371553",
  " Female Once every few weeks  Some ed after H.S. 293 279.0163  24.82754319  1.55330632 280.9736  2.213633",
  " Female Once every few weeks        I Don't Know 238 246.1979  21.90728282  1.69820519 256.3427  2.593089",
  " Female Once every few weeks             Omitted   3   3.6839   0.32780231  0.22221000 314.9975  6.349582",
  " Female Once every few weeks            Multiple   0   0.0000   0.00000000          NA       NA        NA",
  " Female    About once a week Did not finish H.S. 179 179.8877  17.92442311  1.97991477 263.5835  4.033825",
  " Female    About once a week      Graduated H.S. 341 374.5580  37.32181840  1.73884157 270.8901  2.059339",
  " Female    About once a week  Some ed after H.S. 294 297.4837  29.64195833  2.52591357 287.3299  2.680853",
  " Female    About once a week        I Don't Know 136 144.7233  14.42056163  1.78256095 259.4214  5.090724",
  " Female    About once a week             Omitted   2   2.4878   0.24789010  0.18007066 236.0346 29.429139",
  " Female    About once a week            Multiple   4   4.4494   0.44334842  0.24680401 245.1905 10.552792",
  " Female  2 or 3 times a week Did not finish H.S. 210 233.0401  19.69274631  1.84788931 264.5228  3.795271",
  " Female  2 or 3 times a week      Graduated H.S. 367 360.9226  30.49928831  1.37541795 273.5378  2.303132",
  " Female  2 or 3 times a week  Some ed after H.S. 373 355.9466  30.07879799  1.75930337 285.5323  2.204383",
  " Female  2 or 3 times a week        I Don't Know 197 221.6541  18.73058739  1.48982635 264.9600  3.556201",
  " Female  2 or 3 times a week             Omitted   6   8.3724   0.70749862  0.35568288 269.3777 21.036096",
  " Female  2 or 3 times a week            Multiple   2   3.4446   0.29108138  0.22778894 278.1615 12.995606",
  " Female            Every day Did not finish H.S. 187 211.7498  18.55141968  1.40156898 259.5774  3.365343",
  " Female            Every day      Graduated H.S. 361 356.2339  31.20968512  1.75205623 263.8997  2.533536",
  " Female            Every day  Some ed after H.S. 371 366.2800  32.08982488  1.76279222 284.2834  1.954843",
  " Female            Every day        I Don't Know 193 203.3300  17.81376022  1.49573474 248.0493  3.198495",
  " Female            Every day             Omitted   2   0.2870   0.02514410  0.02502224 231.7420        NA",
  " Female            Every day            Multiple   3   3.5403   0.31016601  0.24172024 269.4525 11.741929",
  " Female              Omitted Did not finish H.S.   1   1.7223   2.13525117  2.07803300 279.7860        NA",
  " Female              Omitted      Graduated H.S.   5  11.3386  14.05722518  8.22953780 215.9616 43.566724",
  " Female              Omitted  Some ed after H.S.   2   0.9568   1.18620932  1.04126567 304.0706 64.226485",
  " Female              Omitted        I Don't Know   4   6.6022   8.18519148  4.83360599 182.8789 22.518459",
  " Female              Omitted             Omitted 245  60.0404  74.43612285  8.75090822 257.7866  6.690911",
  " Female              Omitted            Multiple   0   0.0000   0.00000000          NA       NA        NA",
  " Female             Multiple Did not finish H.S.   0   0.0000   0.00000000          NA       NA        NA",
  " Female             Multiple      Graduated H.S.   0   0.0000   0.00000000          NA       NA        NA",
  " Female             Multiple  Some ed after H.S.   0   0.0000   0.00000000          NA       NA        NA",
  " Female             Multiple        I Don't Know   1   0.1435 100.00000000          NA 293.5940        NA",
  " Female             Multiple             Omitted   0   0.0000   0.00000000          NA       NA        NA",
  " Female             Multiple            Multiple   0   0.0000   0.00000000          NA       NA        NA"
)
estwith0REF <- c(
  "",
  "Formula: composite ~ b003501 + m815401 ",
  "",
  "Plausible values: 5", 
  "jrrIMax: 1",
  "Weight variable: 'origwt'",
  "Variance method: jackknife",
  "JK replicates: 62",
  "full data n: 17606",
  "n used: 11220",
  "",
  "",
  "Summary Table:",
  "             b003501            m815401    N     WTD_N         PCT     SE(PCT)     MEAN  SE(MEAN)", 
  " Did not finish H.S. Easier than others  860  941.6337 49.83286267  1.64889511 268.3298  1.803212", 
  " Did not finish H.S.  As hard as others  610  660.9430 34.97823171  1.80714925 260.0554  2.031126", 
  " Did not finish H.S. Harder than others  158  161.3728  8.54012402  0.73901762 255.5587  2.911688", 
  " Did not finish H.S.        Much harder   71   67.3144  3.56239295  0.57731370 237.5406  7.030221", 
  " Did not finish H.S.            Omitted   47   54.7796  2.89902993  0.59089141 237.9851  6.155979", 
  " Did not finish H.S.           Multiple    2    3.5403  0.18735872  0.13696789 241.7904 10.080054", 
  "      Graduated H.S. Easier than others 1755 1836.0455 51.02778274  1.21872773 275.0705  1.128695", 
  "      Graduated H.S.  As hard as others 1211 1222.7080 33.98177125  1.19322392 267.7533  1.180079", 
  "      Graduated H.S. Harder than others  334  332.6968  9.24638307  0.67937504 263.6961  2.648693", 
  "      Graduated H.S.        Much harder  101  106.5451  2.96112499  0.45568508 237.5003  5.862016", 
  "      Graduated H.S.            Omitted   99   97.2152  2.70182635  0.42176804 254.6397  5.727409", 
  "      Graduated H.S.           Multiple    4    2.9185  0.08111160  0.05140085 255.7386 16.510320", 
  "  Some ed after H.S. Easier than others 1479 1558.4164 53.88140863  1.28505307 290.1307  1.112578", 
  "  Some ed after H.S.  As hard as others 1064 1015.5016 35.11042150  1.29074248 278.2807  1.266867", 
  "  Some ed after H.S. Harder than others  250  208.7832  7.21856682  0.59140478 269.7629  3.847818", 
  "  Some ed after H.S.        Much harder   57   47.6512  1.64751460  0.30681445 254.0030  6.018615", 
  "  Some ed after H.S.            Omitted   69   60.6641  2.09742862  0.39367631 263.6685  4.516513", 
  "  Some ed after H.S.           Multiple    2    1.2917  0.04465983  0.04026678 251.3682  7.558644", 
  "        I Don't Know Easier than others 1078 1204.2905 46.34193654  1.44483641 264.6348  1.749268", 
  "        I Don't Know  As hard as others  868  928.3830 35.72482393  1.24387807 256.7520  1.884006", 
  "        I Don't Know Harder than others  274  273.8016 10.53607611  0.71134338 255.4384  2.958810", 
  "        I Don't Know        Much harder  103   89.4648  3.44266777  0.46714337 243.9997  4.759095", 
  "        I Don't Know            Omitted   93  101.9524  3.92319930  0.56310218 237.8497  3.975815", 
  "        I Don't Know           Multiple    1    0.8133  0.03129635  0.03132223 292.2200        NA", 
  "             Omitted Easier than others   31   37.3172 17.01982100  3.41767224 286.8190  8.815679", 
  "             Omitted  As hard as others   29   27.4135 12.50289044  3.13717532 258.3821  7.985184", 
  "             Omitted Harder than others    7    5.5018  2.50928931  1.09558321 252.8294 32.209054", 
  "             Omitted        Much harder    4    5.9324  2.70567958  1.49181111 249.4781  8.429959", 
  "             Omitted            Omitted  531  143.0924 65.26231966  4.35263126 252.1139  3.665201", 
  "             Omitted           Multiple    0    0.0000  0.00000000          NA       NA        NA", 
  "            Multiple Easier than others   13    8.0853 32.81531568 12.57870084 252.9200  8.349768", 
  "            Multiple  As hard as others   13   13.8744 56.31118399  9.39004975 251.1944  7.175494", 
  "            Multiple Harder than others    0    0.0000  0.00000000          NA       NA        NA", 
  "            Multiple        Much harder    1    0.1435  0.58241473  0.61353570 240.2340        NA", 
  "            Multiple            Omitted    1    2.5356 10.29108560 10.49245307 280.2800        NA", 
  "            Multiple           Multiple    0    0.0000  0.00000000          NA       NA        NA"
)

logit1REF <- c(
  "",
  "Formula: I(composite > 300) ~ dsex + b013801",
  "Family: binomial (logit)",
  "",
  "jrrIMax: 1",
  "Weight variable: 'origwt'",
  "Variance method: jackknife",
  "JK replicates: 62",
  "full data n: 17606",
  "n used: 16359",
  "",
  "Coefficients:",
  "                  coef       se        t  dof Pr(>|t|)    ",
  "(Intercept)    -2.4626   0.1435 -17.1647 38.6  < 2e-16 ***",
  "dsexFemale     -0.2469   0.0527  -4.6860 60.0  1.6e-05 ***",
  "b01380111-25    0.5953   0.1550   3.8400 42.6    4e-04 ***",
  "b01380126-100   1.5613   0.1596   9.7840 40.1  3.5e-12 ***",
  "b013801>100     2.3546   0.1441  16.3358 57.3  < 2e-16 ***",
  "---",
  "Signif. codes:  0 '***' 0.001 '**' 0.01 '*' 0.05 '.' 0.1 ' ' 1"
)
gap0REF <- c(
  "Call: gap(variable = \"b003501\", data = sdf, groupA = m815401 %in% \"Multiple\", ",
  "    groupB = \"default\", targetLevel = \"Multiple\", dropOmittedLevels = FALSE, ",
  "    returnVarEstInputs = TRUE, returnSimpleDoF = TRUE, returnSimpleN = TRUE)",
  "",
  "Labels:",
  " group              definition nFullData nUsed",
  "     A m815401 %in% \"Multiple\"     17606    18",
  "     B                 default     17606 16915",
  "",
  "Percentage:",
  "       pctA   pctAse   dofA pctB pctBse dofB  diffAB covAB diffABse diffABpValue  dofAB",
  " 0.09917399 0.031552 12.846  100      0    0 -99.901     0 0.031552    < 2.2e-16 12.846",
  "",
  "Results:",
  " estimateA estimateAse dofA estimateB estimateBse  dofB  diffAB covAB diffABse diffABpValue dofAB",
  "         0          NA   NA    0.2195      0.0664 9.757 -0.2195     0       NA           NA    NA"
)
wt1REF <- c(
  "Wald test:",
  "----------",
  "H0:",
  "b017451Once every few weeks = 0",
  "b017451About once a week = 0",
  "b0174512 or 3 times a week = 0",
  "b017451Every day = 0",
  "",
  "Chi-square test:",
  "X2 = 159.9, df = 4, P(> X2) = 0.0",
  "",
  "F test:",
  "W = 38.0, df1 = 4, df2 = 59, P(> W) = 1.1e-15"
)
wt2REF <- c(
  "Wald test:",
  "----------",
  "H0:",
  "b017451Once every few weeks = 0",
  "b017451About once a week = 0",
  "b0174512 or 3 times a week = 0",
  "b017451Every day = 0",
  "",
  "Chi-square test:",
  "X2 = 185.8, df = 4, P(> X2) = 0.0",
  "",
  "F test:",
  "W = 44.2, df1 = 4, df2 = 59, P(> W) = 0"
)
wt3REF <- c(
  "Wald test:", "----------",
  "H0:",
  "b017451Once every few weeks = 0",
  "b017451About once a week = 0",
  "b0174512 or 3 times a week = 0",
  "b017451Every day = 0",
  "",
  "Chi-square test:",
  "X2 = 180.3, df = 4, P(> X2) = 0.0", "",
  "F test:",
  "W = 42.9, df1 = 4, df2 = 59, P(> W) = 0"
)
wt4REF <- c(
  "Wald test:", "----------",
  "H0:",
  "b017451Once every few weeks = 0",
  "b017451About once a week = 0",
  "b0174512 or 3 times a week = 0",
  "b017451Every day = 0",
  "",
  "Chi-square test:",
  "X2 = 159.9, df = 4, P(> X2) = 0.0",
  "",
  "F test:",
  "W = 38.0, df1 = 4, df2 = 59, P(> W) = 1.1e-15"
)
es_norhsREF <- c(
  "",
  "Formula: composite ~ 1 ",
  "",
  "Plausible values: 5",
  "jrrIMax: 1",
  "Weight variable: 'origwt'",
  "Variance method: jackknife",
  "JK replicates: 62",
  "full data n: 17606",
  "n used: 16915",
  "",
  "",
  "Summary Table:",
  "     N    WTD_N PCT     MEAN  SE(MEAN)",
  " 16915 16932.46 100 275.8892 0.8217878"
)
dplO <- c(
  "",
  "Formula: composite - geometry ~ avg_5",
  "",
  "Weight variable: 'origwt'",
  "Variance method: jackknife",
  "JK replicates: 62",
  "Plausible values: 5",
  "jrrIMax: 1",
  "full data n: 17606",
  "n used: 15144", "",
  "Coefficients:",
  "                   coef          se       t    dof  Pr(>|t|)    ",
  "(Intercept) -32.1895692   1.7984639 -17.898 58.289 < 2.2e-16 ***",
  "avg_5         0.1264752   0.0063834  19.813 53.390 < 2.2e-16 ***",
  "---",
  "Signif. codes:  0 '***' 0.001 '**' 0.01 '*' 0.05 '.' 0.1 ' ' 1",
  "",
  "Multiple R-squared: 0.113",
  ""
)
gapPSUREF <- c(
  "Call: gap(variable = \"composite\", data = sdf, groupA = dsex %in% \"Male\", ", 
  "    groupB = dsex %in% \"Female\", returnNumberOfPSU = TRUE)", 
  "",
  "Labels:",
  " group         definition nFullData nUsed nPSU", 
  "     A   dsex %in% \"Male\"     17606  8486  124",
  "     B dsex %in% \"Female\"     17606  8429  124", 
  "",
  "Percentage:",
  "     pctA  pctAse  pctB  pctBse  diffAB    covAB diffABse diffABpValue  dofAB", 
  " 50.27015 0.50168 49.73 0.50168 0.54029 -0.25168   1.0034       0.5925 53.457", 
  "",
  "Results:",
  " estimateA estimateAse estimateB estimateBse diffAB   covAB diffABse diffABpValue dofAB", 
  "  276.7235     0.82071    275.05     0.94025 1.6778 0.56766  0.64987      0.01259 53.71"
)
sPV_wREF <- c(
  "Estimates are weighted using the weight variable 'origwt'",
  "   Variable     N Weighted N    Min.  1st Qu.   Median     Mean  3rd Qu.    Max.       SD NA's Zero weights",
  "1 composite 16915   16932.46 126.110 251.9626 277.4784 275.8892 301.1827 404.184 36.57130    0            0",
  "2   algebra 16915   16932.46 109.842 254.7982 279.8320 278.9366 304.0186 412.152 36.65571    0            0"
)
sPVREF <- c(
  "Estimates are not weighted.", "  Variable     N   Min.  1st Qu. Median     Mean  3rd Qu.   Max.       SD NA's",
  "1   mrpcm1 16915 130.53 252.0600 277.33 275.8606 300.7200 410.80 35.89864    0",
  "2   mrpcm2 16915 124.16 252.2100 277.33 275.6399 300.6900 408.58 36.08483    0",
  "3   mrpcm3 16915 115.09 252.0017 277.19 275.6570 300.5600 398.17 36.09278    0",
  "4   mrpcm4 16915 137.19 252.4717 277.44 275.7451 300.5767 407.41 35.91078    0",
  "5   mrpcm5 16915 123.58 252.4900 277.16 275.6965 300.5000 395.96 36.10905    0"
)
sDiscrete_wREF <- c(
  "Estimates are weighted using the weight variable 'origwt'",
  "                b017451   dsex    N Weighted N Weighted Percent Weighted Percent SE",
  "1  Never or hardly ever   Male 2350    2434.84             61.6                1.07",
  "2  Never or hardly ever Female 1487    1517.61             38.4                1.07",
  "3  Once every few weeks   Male 1603    1638.75             51.4                0.93",
  "4  Once every few weeks Female 1544    1552.15             48.6                0.93",
  "5     About once a week   Male 1384    1423.31             48.4                1.27",
  "6     About once a week Female 1469    1514.40             51.6                1.27",
  "7   2 or 3 times a week   Male 1535    1563.39             45.6                1.01",
  "8   2 or 3 times a week Female 1827    1862.50             54.4                1.01",
  "9             Every day   Male 1291    1332.89             41.3                1.22",
  "10            Every day Female 1841    1890.92             58.7                1.22",
  "11              Omitted   Male  316     111.80             57.5                3.97",
  "12              Omitted Female  259      82.53             42.5                3.97",
  "13             Multiple   Male    7       6.98             94.8                4.17",
  "14             Multiple Female    2       0.38              5.2                4.17"
)
sDiscreteREF <- c(
  "Estimates are not weighted.",
  "    dsex    N Percent",
  "1   Male 8486   50.17",
  "2 Female 8429   49.83"
)
cor_nocondenseREF <- c(
  "Method: Pearson",
  "full data n: 17606",
  "n used: 14816",
  "",
  "Correlation: 0.1783",
  "Standard Error: 0.06575",
  "Confidence Interval: [0.03961, 0.3103]",
  "",
  "Correlation Levels:",
  "  Levels for Variable 'c046501' (Lowest level first):",
  "    1. 0%",
  "    2. 1-5%",
  "    3. 6-10%",
  "    4. 11-25%",
  "    5. 26-50%",
  "    8. Over 90%",
  "  Levels for Variable 'c044006' (Lowest level first):",
  "    1. None",
  "    2. 1-5%",
  "    3. 6-10%",
  "    4. 11-25%",
  "    5. 26-50%",
  "    6. 51-75%",
  "    7. 76-90%",
  "    8. Over 90%"
)
stdCoefREF <- c(
  "                               coef     se       t   dof  Pr(>|t|)  stdCoef    stdSE",
  "(Intercept)                 270.411 1.0244 263.961 54.67 0.000e+00       NA       NA",
  "dsexFemale                   -2.959 0.6042  -4.896 54.99 8.947e-06 -0.04070 0.008412",
  "b017451Once every few weeks   4.233 1.1833   3.578 57.32 7.131e-04  0.04576 0.012902",
  "b017451About once a week     11.226 1.2585   8.920 54.68 2.983e-12  0.11752 0.013753",
  "b0174512 or 3 times a week   14.946 1.1866  12.595 72.58 0.000e+00  0.16595 0.013147",
  "b017451Every day              7.530 1.3085   5.755 48.47 5.755e-07  0.08172 0.014526"
)
rq1REF <- c(
  "",
  "Formula: composite ~ dsex + b017451",
  "",
  "tau: 0.8",
  "jrrIMax: 1",
  "Weight variable: 'origwt'",
  "Variance method: jackknife",
  "JK replicates: 62",
  "full data n: 17606",
  "n used: 16331",
  "",
  "Coefficients:",
  "                              coef     se      t  dof Pr(>|t|)    ",
  "(Intercept)                 299.77   1.81 165.59 29.4  < 2e-16 ***",
  "dsexFemale                   -4.63   1.29  -3.59 58.6  0.00069 ***",
  "b017451Once every few weeks   6.59   1.91   3.45 46.0  0.00120 ** ",
  "b017451About once a week     12.48   2.30   5.44 67.8  8.0e-07 ***",
  "b0174512 or 3 times a week   16.54   2.46   6.72 29.9  1.9e-07 ***",
  "b017451Every day             12.74   1.69   7.53 50.3  8.7e-10 ***",
  "---",
  "Signif. codes:  0 '***' 0.001 '**' 0.01 '*' 0.05 '.' 0.1 ' ' 1"
)
rq1SREF <- c(
  "",
  "Formula: composite ~ dsex + b017451",
  "",
  "tau: 0.8",
  "jrrIMax: 1",
  "Weight variable: ‘origwt’",
  "Variance method: jackknife",
  "JK replicates: 62",
  "full data n: 17606",
  "n used: 16331",
  "",
  "Coefficients:",
  "                                coef       se        t    dof  Pr(>|t|)    ",
  "(Intercept)                 299.7680   1.8103 165.5883 29.389 < 2.2e-16 ***",
  "dsexFemale                   -4.6280   1.2908  -3.5852 58.617 0.0006868 ***",
  "b017451Once every few weeks   6.5880   1.9086   3.4518 46.045 0.0012041 ** ",
  "b017451About once a week     12.4800   2.2959   5.4359 67.782 8.032e-07 ***",
  "b0174512 or 3 times a week   16.5420   2.4616   6.7201 29.867 1.943e-07 ***",
  "b017451Every day             12.7420   1.6932   7.5253 50.343 8.717e-10 ***",
  "---",
  "Signif. codes:  0 ‘***’ 0.001 ‘**’ 0.01 ‘*’ 0.05 ‘.’ 0.1 ‘ ’ 1"
)
rq2REF <- c(
  "                (Intercept)                  dsexFemale b017451Once every few weeks    b017451About once a week  b0174512 or 3 times a week            b017451Every day ",
  "                     299.43                       -4.63                        7.29                       13.15                       17.02                       13.12 "
)
rq2SREF <- c(
  "",
  "Formula: mrpcm1 ~ dsex + b017451",
  "",
  "tau: 0.8",
  "Weight variable: 'origwt'",
  "Variance method: jackknife",
  "JK replicates: 62",
  "full data n: 17606",
  "n used: 16331",
  "",
  "Coefficients:",
  "                                coef       se        t    dof  Pr(>|t|)    ",
  "(Intercept)                 299.4300   1.6469 181.8103 29.389 < 2.2e-16 ***",
  "dsexFemale                   -4.6300   1.1182  -4.1405 58.617 0.0001125 ***",
  "b017451Once every few weeks   7.2900   1.8336   3.9758 46.045 0.0002456 ***",
  "b017451About once a week     13.1500   2.2236   5.9137 67.782 1.213e-07 ***",
  "b0174512 or 3 times a week   17.0200   2.3063   7.3798 29.867 3.286e-08 ***",
  "b017451Every day             13.1200   1.4556   9.0134 50.343 4.420e-12 ***",
  "---",
  "Signif. codes:  0 '***' 0.001 '**' 0.01 '*' 0.05 '.' 0.1 ' ' 1"
)
logit2tREF <- c(
  "", "Formula: iep ~ dsex + b013801", "Family: binomial (logit)",
  "",
  "Weight variable: 'origwt'", "Variance method: Taylor series",
  "full data n: 17606", "n used: 16294", "", "Coefficients:",
  "                   coef        se         t    dof Pr(>|t|)    ",
  "(Intercept)    -3.78974   0.14463 -26.20351 34.236   <2e-16 ***",
  "dsexFemale     -0.15327   0.13700  -1.11876 34.852   0.2709    ",
  "b01380111-25    0.14963   0.16470   0.90851 59.574   0.3673    ",
  "b01380126-100  -0.22653   0.16072  -1.40948 47.152   0.1653    ",
  "b013801>100     0.14767   0.21253   0.69482 29.369   0.4926    ",
  "---",
  "Signif. codes:  0 '***' 0.001 '**' 0.01 '*' 0.05 '.' 0.1 ' ' 1"
)
assignTableREF <- structure(c(8486L, 0L, 0L, 8429L),
  .Dim = c(2L, 2L),
  .Dimnames = structure(
    list(
      c("Male", "Female"),
      c("Male", "Female")
    ),
    .Names = c("", "")
  ), class = "table"
)
sum2ResBREF <- c(
  "Estimates are weighted using the weight variable 'origwt'",
  "     dsex               pared    N Weighted N Weighted Percent Weighted Percent SE",
  "1    Male Did not finish H.S.  539      593.2            6.968               0.392",
  "2    Male      Graduated H.S. 1461     1490.4           17.510               0.673",
  "3    Male  Some ed after H.S. 1383     1449.4           17.028               0.556",
  "4    Male   Graduated college 3775     3769.9           44.289               0.931",
  "5    Male        I Don't Know  996     1082.1           12.713               0.543",
  "6    Male             Omitted  326      124.3            1.460               0.155",
  "7    Male            Multiple    6        2.7            0.031               0.015",
  "8  Female Did not finish H.S.  741      821.4            9.754               0.522",
  "9  Female      Graduated H.S. 1630     1688.9           20.057               0.619",
  "10 Female  Some ed after H.S. 1522     1513.3           17.972               0.470",
  "11 Female   Graduated college 3490     3471.1           41.222               0.928",
  "12 Female        I Don't Know  791      854.0           10.142               0.515",
  "13 Female             Omitted  251       65.4            0.777               0.131",
  "14 Female            Multiple    4        6.4            0.076               0.042"
)
mmlIntREF <- c(
  "  (Intercept) Population SD ",
  "       279.64         33.96 "
)
mmlSumREF <- c(
  "Call:",
  "mml.sdf(formula = algebra ~ 1, data = subset(sdf, dsex == \"Female\"), ",
  "    weightVar = \"origwt\", verbose = TRUE)",
  "Summary Call:",
  "summary.mml.sdf(object = mmlNAEP)",
  "",
  "Summary:",
  "            Estimate StdErr t.value  dof Pr(>|t|)    ",
  "(Intercept)   279.64   0.95  294.43 40.5   <2e-16 ***",
  "---",
  "Signif. codes:  0 '***' 0.001 '**' 0.01 '*' 0.05 '.' 0.1 ' ' 1",
  "",
  "Residual Variance Estimate:",
  "              Estimate StdErr",
  "Population SD    33.96 0.7122",
  "",
  "Convergence = converged",
  "Iterations = 11",
  "LogLike = -35401.05",
  "Observations = 8237",
  "Weighted observations = 8226.97"
)
mmlDsexIntREF <- c(
  "  (Intercept)    dsexFemale Population SD ",
  "       279.23          0.34         34.85 "
)


pdf_estREF <- c(
  "% LaTeX script for EdSurvey Table:",
  "\\begin{table}[ht]", 
  "\\centering",
  "\\begin{tabular}{lll}",
  "  \\hline",
  "Talk about studies at home & Male & Female \\\\ ",
  "  \\hline",
  "Never or hardly ever & 29.01 (0.696) & 18.20 (0.508) \\\\ ", 
  "  Once every few weeks & 19.52 (0.502) & 18.62 (0.489) \\\\ ", 
  "  About once a week & 16.96 (0.506) & 18.16 (0.578) \\\\ ", 
  "  2 or 3 times a week & 18.63 (0.481) & 29.01 (0.696) \\\\ ", 
  "  Every day & 15.88 (0.587) & 29.01 (0.696) \\\\ ",
  "   \\hline", 
  "\\end{tabular}",
  "\\end{table}"
)

lm10_head <- 
list(formula = composite ~ dsex + b017451, coef = c(`(Intercept)` = 270.411120956747, 
dsexFemale = -2.95857830863405, `b017451Once every few weeks` = 4.23341438050276, 
`b017451About once a week` = 11.2261231533783, `b0174512 or 3 times a week` = 14.9459085095952, 
`b017451Every day` = 7.52998369846192), se = c(`(Intercept)` = 1.02443397803618, 
dsexFemale = 0.604228514050488, `b017451Once every few weeks` = 1.18326707469577, 
`b017451About once a week` = 1.25853689767647, `b0174512 or 3 times a week` = 1.18664605765311, 
`b017451Every day` = 1.3084557511019), Vimp = c(`(Intercept)` = 0.0317123088999927, 
dsexFemale = 0.0118044139976679, `b017451Once every few weeks` = 0.115883064314653, 
`b017451About once a week` = 0.249949470571965, `b0174512 or 3 times a week` = 0.0621448682665872, 
`b017451Every day` = 0.216972364588427), Vjrr = c(`(Intercept)` = 1.01775266645504, 
dsexFemale = 0.353287683193993, `b017451Once every few weeks` = 1.28423790574442, 
`b017451About once a week` = 1.33396565224115, `b0174512 or 3 times a week` = 1.34598399787709, 
`b017451Every day` = 1.4950840880032), M = 5L, varm = structure(c(1.01775266645504, 
0.353287683193993, 1.28423790574442, 1.33396565224115, 1.34598399787709, 
1.4950840880032), dim = c(1L, 6L)), coefm = structure(c(270.299026109663, 
270.3698547706, 270.358978287715, 270.697727097624, 270.330018518134, 
-2.93888691554455, -3.03862500768519, -2.82749375810408, -3.0741562379871, 
-2.91372962384933, 4.38903707262901, 4.32933570873935, 3.8893149993103, 
3.9404503137907, 4.61893380804442, 11.4467530795666, 11.2824696023128, 
11.5962902897723, 10.4362406942504, 11.3688621009895, 15.3123206803453, 
14.9766415511688, 14.8990230698195, 14.7059405034579, 14.8356167431845, 
7.99325875545627, 7.40171989229546, 7.73429696289416, 6.8698176274791, 
7.65082525418462), dim = 5:6, dimnames = list(NULL, c("(Intercept)", 
"dsexFemale", "b017451Once every few weeks", "b017451About once a week", 
"b0174512 or 3 times a week", "b017451Every day"))), coefmat = structure(list(
    coef = c(270.411120956747, -2.95857830863405, 4.23341438050276, 
    11.2261231533783, 14.9459085095952, 7.52998369846192), se = c(1.02443397803618, 
    0.604228514050488, 1.18326707469577, 1.25853689767647, 1.18664605765311, 
    1.3084557511019), t = c(263.961491666959, -4.89645595968488, 
    3.57773360810468, 8.91997936183212, 12.5950854622603, 5.75486308354001
    ), dof = c(54.6700206144557, 54.9911209627616, 57.3160571925223, 
    54.6832034093795, 72.5820287251234, 48.4697539222567), `Pr(>|t|)` = c(0, 
    8.94739811057101e-06, 0.00071311498547777, 2.98339131177272e-12, 
    0, 5.75502820066021e-07)), row.names = c("(Intercept)", "dsexFemale", 
"b017451Once every few weeks", "b017451About once a week", "b0174512 or 3 times a week", 
"b017451Every day"), class = "data.frame"), r.squared = 0.0223931751818003, 
    weight = "origwt", npv = 5L, jrrIMax = 1, njk = 62L, varMethod = "jackknife", 
    residuals = structure(c(40.0688953447908, 9.75133419850852, 
    67.7374736534249, 70.8188953447908, 6.75404297138402, 42.5929705336575, 
    25.7388953447908, 5.25133419850852, 63.0474736534248, 43.8488953447908, 
    -26.605957028616, 53.2329705336575, 18.6688953447908, 1.7713341985085, 
    54.4974736534249, 49.9288953447908, -8.68595702861597, 42.7129705336575, 
    51.0288953447908, 11.3513341985085, 77.4774736534249, 55.4088953447908, 
    5.81404297138403, 48.7129705336575, 37.7588953447908, 7.55133419850853, 
    67.2774736534249, 49.3788953447908, 13.354042971384, 34.6629705336575
    ), dim = 6:5), fitted.values = c(277.941104655209, 278.678665801491, 
    274.982526346575, 277.941104655209, 271.685957028616, 285.357029466342
    ), residual.df = 16325L, PV.residuals = structure(c(39.7177151348806, 
    9.62310772631491, 67.3666020504252, 70.4677151348806, 6.69082373325244, 
    42.3386532099916, 25.9084253371047, 5.31630063477252, 63.2970503447899, 
    44.0184253371047, -26.580565471654, 53.2435036782313, 18.5167247493907, 
    1.32222518061661, 54.2142185074948, 49.7767247493907, -8.42079952892141, 
    42.8119986424654, 51.4024552748965, 11.9701884461122, 77.9666115128836, 
    55.7824552748965, 5.93597882657201, 48.6663323989176, 37.7191562276816, 
    7.44484900472605, 67.1928858515309, 49.3391562276816, 13.0047772976712, 
    34.8543647386817), dim = 6:5), PV.fitted.values = structure(c(278.292284865119, 
    278.806892273685, 275.353397949575, 278.292284865119, 271.749176266748, 
    285.611346790008, 277.771574662895, 278.613699365227, 274.73294965521, 
    277.771574662895, 271.660565471654, 285.346496321769, 278.093275250609, 
    279.127774819383, 275.265781492505, 278.093275250609, 271.420799528921, 
    285.258001357535, 277.567544725104, 278.059811553888, 274.493388487116, 
    277.567544725104, 271.564021173428, 285.403667601082, 277.980843772318, 
    278.785150995274, 275.067114148469, 277.980843772318, 272.035222702329, 
    285.165635261318), dim = 6:5), B = structure(c(0.0264269240833273, 
    -0.0106254655135796, -0.029673103849521, -0.0710799558654692, 
    -0.0249319481634757, -0.0640748555734966, -0.0106254655135796, 
    0.00983701166472321, 0.000357587169684912, 0.0365129972962016, 
    0.00534942383801708, 0.031973037584361, -0.029673103849521, 
    0.000357587169684912, 0.0965692202622109, 0.0497003453877256, 
    0.0259714094329351, 0.0573701283243995, -0.0710799558654692, 
    0.0365129972962016, 0.0497003453877256, 0.208291225476638, 
    0.0597553317741062, 0.177329395929916, -0.0249319481634757, 
    0.00534942383801708, 0.0259714094329351, 0.0597553317741062, 
    0.051787390222156, 0.0753298180705498, -0.0640748555734966, 
    0.031973037584361, 0.0573701283243995, 0.177329395929916, 
    0.0753298180705498, 0.180810303823689), dim = c(6L, 6L), dimnames = list(
        c("(Intercept)", "dsexFemale", "b017451Once every few weeks", 
        "b017451About once a week", "b0174512 or 3 times a week", 
        "b017451Every day"), c("(Intercept)", "dsexFemale", "b017451Once every few weeks", 
        "b017451About once a week", "b0174512 or 3 times a week", 
        "b017451Every day"))), U = structure(c(1.01775266645504, 
    -0.0539588947946272, -0.68525863004781, -0.466713890727058, 
    -0.428898034193583, -0.568765736440115, -0.0539588947946272, 
    0.353287683193993, -0.134920749671854, -0.0520955931471992, 
    -0.0159324173319144, -0.11263633925747, -0.68525863004781, 
    -0.134920749671854, 1.28423790574442, 0.736185103282417, 
    0.594797632018768, 0.686080650535171, -0.466713890727058, 
    -0.0520955931471992, 0.736185103282417, 1.33396565224115, 
    0.63980493976393, 0.729477596903082, -0.428898034193583, 
    -0.0159324173319144, 0.594797632018768, 0.63980493976393, 
    1.34598399787709, 0.4810029673653, -0.568765736440115, -0.11263633925747, 
    0.686080650535171, 0.729477596903082, 0.4810029673653, 1.4950840880032
    ), dim = c(6L, 6L), dimnames = list(c("(Intercept)", "dsexFemale", 
    "b017451Once every few weeks", "b017451About once a week", 
    "b0174512 or 3 times a week", "b017451Every day"), c("(Intercept)", 
    "dsexFemale", "b017451Once every few weeks", "b017451About once a week", 
    "b0174512 or 3 times a week", "b017451Every day"))), rbar = 0.0857835117931858, 
    Ttilde = structure(c(1.10505906432044, -0.0585876782825894, 
    -0.744042521819899, -0.506750247276286, -0.465690413767903, 
    -0.617556458699585, -0.0585876782825894, 0.383593941331652, 
    -0.146494725392475, -0.056564536076315, -0.0172991560420006, 
    -0.122298679994505, -0.744042521819899, -0.146494725392475, 
    1.39440434327711, 0.799337646771812, 0.645821461699609, 0.744935058111432, 
    -0.506750247276286, -0.056564536076315, 0.799337646771812, 
    1.44839791050188, 0.694689654359507, 0.792054746939883, -0.465690413767903, 
    -0.0172991560420006, 0.645821461699609, 0.694689654359507, 
    1.46144723203242, 0.522265091088839, -0.617556458699585, 
    -0.122298679994505, 0.744935058111432, 0.792054746939883, 
    0.522265091088839, 1.62333765149823), dim = c(6L, 6L), dimnames = list(
        c("(Intercept)", "dsexFemale", "b017451Once every few weeks", 
        "b017451About once a week", "b0174512 or 3 times a week", 
        "b017451Every day"), c("(Intercept)", "dsexFemale", "b017451Once every few weeks", 
        "b017451About once a week", "b0174512 or 3 times a week", 
        "b017451Every day"))), waldDenomBaseDof = 63, n0 = 17606L, 
    nUsed = 16331L, Xstdev = list(outcome.std = 36.3450748753527, 
        `(Intercept)` = 0, dsexFemale = 0.500012547576328, `b017451Once every few weeks` = 0.392880957783438, 
        `b017451About once a week` = 0.380480563361107, `b0174512 or 3 times a week` = 0.403543023481001), 
    varSummary = list(structure(list(summary = structure(list(
        Variable = c("mrpcm1", "mrpcm2", "mrpcm3", "mrpcm4", 
        "mrpcm5"), N = c(16331, 16331, 16331, 16331, 16331), 
        Min. = c(130.53, 124.16, 115.09, 137.19, 123.58), `1st Qu.` = c(252.451666666667, 
        252.691666666667, 252.371666666667, 252.815, 252.86), 
        Median = c(277.5, 277.5, 277.47, 277.64, 277.33), Mean = c(276.139280509461, 
        275.92952544241, 275.934778029514, 276.016936501133, 
        275.980287796216), `3rd Qu.` = c(300.798333333333, 300.76, 
        300.678333333333, 300.828333333333, 300.61), Max. = c(410.8, 
        408.58, 398.17, 407.41, 395.96), SD = c(35.694086381693, 
        35.8508676252172, 35.9087308785062, 35.7219798072453, 
        35.8801154841422), `NA's` = c(0, 0, 0, 0, 0)), class = "data.frame", row.names = c(NA, 
    -5L))), class = "summary2"), structure(list(summary = structure(list(
        dsex = structure(1:2, levels = c("Male", "Female"), class = "factor"), 
        N = c(8163L, 8168L), Percent = c(49.9846916906497, 50.0153083093503
        )), row.names = c(NA, -2L), class = "data.frame")), class = "summary2"), 
        structure(list(summary = structure(list(b017451 = structure(1:5, levels = c("Never or hardly ever", 
        "Once every few weeks", "About once a week", "2 or 3 times a week", 
        "Every day"), class = "factor"), N = c(3837L, 3147L, 
        2853L, 3362L, 3132L), Percent = c(23.495193190864, 19.270099810177, 
        17.4698426305799, 20.5866144143041, 19.1782499540751)), row.names = c(NA, 
        -5L), class = "data.frame")), class = "summary2")))

lm1_head <- list(formula = composite ~ dsex + b017451, coef = c(`(Intercept)` = 270.411120956747, 
dsexFemale = -2.95857830863405, `b017451Once every few weeks` = 4.23341438050276, 
`b017451About once a week` = 11.2261231533783, `b0174512 or 3 times a week` = 14.9459085095952, 
`b017451Every day` = 7.52998369846192), se = c(`(Intercept)` = 1.02443397803618, 
dsexFemale = 0.604228514050488, `b017451Once every few weeks` = 1.18326707469577, 
`b017451About once a week` = 1.25853689767647, `b0174512 or 3 times a week` = 1.18664605765311, 
`b017451Every day` = 1.3084557511019), Vimp = c(`(Intercept)` = 0.0317123088999927, 
dsexFemale = 0.0118044139976679, `b017451Once every few weeks` = 0.115883064314653, 
`b017451About once a week` = 0.249949470571965, `b0174512 or 3 times a week` = 0.0621448682665872, 
`b017451Every day` = 0.216972364588427), Vjrr = c(`(Intercept)` = 1.01775266645504, 
dsexFemale = 0.353287683193993, `b017451Once every few weeks` = 1.28423790574442, 
`b017451About once a week` = 1.33396565224115, `b0174512 or 3 times a week` = 1.34598399787709, 
`b017451Every day` = 1.4950840880032), M = 5L, varm = structure(c(1.01775266645504, 
0.353287683193993, 1.28423790574442, 1.33396565224115, 1.34598399787709, 
1.4950840880032), dim = c(1L, 6L)), coefm = structure(c(270.299026109663, 
270.3698547706, 270.358978287715, 270.697727097624, 270.330018518134, 
-2.93888691554455, -3.03862500768519, -2.82749375810408, -3.0741562379871, 
-2.91372962384933, 4.38903707262901, 4.32933570873935, 3.8893149993103, 
3.9404503137907, 4.61893380804442, 11.4467530795666, 11.2824696023128, 
11.5962902897723, 10.4362406942504, 11.3688621009895, 15.3123206803453, 
14.9766415511688, 14.8990230698195, 14.7059405034579, 14.8356167431845, 
7.99325875545627, 7.40171989229546, 7.73429696289416, 6.8698176274791, 
7.65082525418462), dim = 5:6, dimnames = list(NULL, c("(Intercept)", 
"dsexFemale", "b017451Once every few weeks", "b017451About once a week", 
"b0174512 or 3 times a week", "b017451Every day"))), coefmat = structure(list(
    coef = c(270.411120956747, -2.95857830863405, 4.23341438050276, 
    11.2261231533783, 14.9459085095952, 7.52998369846192), se = c(1.02443397803618, 
    0.604228514050488, 1.18326707469577, 1.25853689767647, 1.18664605765311, 
    1.3084557511019), t = c(263.961491666959, -4.89645595968488, 
    3.57773360810468, 8.91997936183212, 12.5950854622603, 5.75486308354001
    ), dof = c(54.6700206144557, 54.9911209627616, 57.3160571925223, 
    54.6832034093795, 72.5820287251234, 48.4697539222567), `Pr(>|t|)` = c(0, 
    8.94739811057101e-06, 0.00071311498547777, 2.98339131177272e-12, 
    0, 5.75502820066021e-07)), row.names = c("(Intercept)", "dsexFemale", 
"b017451Once every few weeks", "b017451About once a week", "b0174512 or 3 times a week", 
"b017451Every day"), class = "data.frame"), r.squared = 0.0223931751818003, 
    weight = "origwt", npv = 5L, jrrIMax = 1, njk = 62L, varMethod = "jackknife", 
    residuals = structure(c(40.0688953447908, 9.75133419850852, 
    67.7374736534249, 70.8188953447908, 6.75404297138402, 42.5929705336575, 
    25.7388953447908, 5.25133419850852, 63.0474736534248, 43.8488953447908, 
    -26.605957028616, 53.2329705336575, 18.6688953447908, 1.7713341985085, 
    54.4974736534249, 49.9288953447908, -8.68595702861597, 42.7129705336575, 
    51.0288953447908, 11.3513341985085, 77.4774736534249, 55.4088953447908, 
    5.81404297138403, 48.7129705336575, 37.7588953447908, 7.55133419850853, 
    67.2774736534249, 49.3788953447908, 13.354042971384, 34.6629705336575
    ), dim = 6:5), fitted.values = c(277.941104655209, 278.678665801491, 
    274.982526346575, 277.941104655209, 271.685957028616, 285.357029466342
    ), residual.df = 16325L, PV.residuals = structure(c(39.7177151348806, 
    9.62310772631491, 67.3666020504252, 70.4677151348806, 6.69082373325244, 
    42.3386532099916, 25.9084253371047, 5.31630063477252, 63.2970503447899, 
    44.0184253371047, -26.580565471654, 53.2435036782313, 18.5167247493907, 
    1.32222518061661, 54.2142185074948, 49.7767247493907, -8.42079952892141, 
    42.8119986424654, 51.4024552748965, 11.9701884461122, 77.9666115128836, 
    55.7824552748965, 5.93597882657201, 48.6663323989176, 37.7191562276816, 
    7.44484900472605, 67.1928858515309, 49.3391562276816, 13.0047772976712, 
    34.8543647386817), dim = 6:5), PV.fitted.values = structure(c(278.292284865119, 
    278.806892273685, 275.353397949575, 278.292284865119, 271.749176266748, 
    285.611346790008, 277.771574662895, 278.613699365227, 274.73294965521, 
    277.771574662895, 271.660565471654, 285.346496321769, 278.093275250609, 
    279.127774819383, 275.265781492505, 278.093275250609, 271.420799528921, 
    285.258001357535, 277.567544725104, 278.059811553888, 274.493388487116, 
    277.567544725104, 271.564021173428, 285.403667601082, 277.980843772318, 
    278.785150995274, 275.067114148469, 277.980843772318, 272.035222702329, 
    285.165635261318), dim = 6:5), B = structure(c(0.0264269240833273, 
    -0.0106254655135796, -0.029673103849521, -0.0710799558654692, 
    -0.0249319481634757, -0.0640748555734966, -0.0106254655135796, 
    0.00983701166472321, 0.000357587169684912, 0.0365129972962016, 
    0.00534942383801708, 0.031973037584361, -0.029673103849521, 
    0.000357587169684912, 0.0965692202622109, 0.0497003453877256, 
    0.0259714094329351, 0.0573701283243995, -0.0710799558654692, 
    0.0365129972962016, 0.0497003453877256, 0.208291225476638, 
    0.0597553317741062, 0.177329395929916, -0.0249319481634757, 
    0.00534942383801708, 0.0259714094329351, 0.0597553317741062, 
    0.051787390222156, 0.0753298180705498, -0.0640748555734966, 
    0.031973037584361, 0.0573701283243995, 0.177329395929916, 
    0.0753298180705498, 0.180810303823689), dim = c(6L, 6L), dimnames = list(
        c("(Intercept)", "dsexFemale", "b017451Once every few weeks", 
        "b017451About once a week", "b0174512 or 3 times a week", 
        "b017451Every day"), c("(Intercept)", "dsexFemale", "b017451Once every few weeks", 
        "b017451About once a week", "b0174512 or 3 times a week", 
        "b017451Every day"))), U = structure(c(1.01775266645504, 
    -0.0539588947946272, -0.68525863004781, -0.466713890727058, 
    -0.428898034193583, -0.568765736440115, -0.0539588947946272, 
    0.353287683193993, -0.134920749671854, -0.0520955931471992, 
    -0.0159324173319144, -0.11263633925747, -0.68525863004781, 
    -0.134920749671854, 1.28423790574442, 0.736185103282417, 
    0.594797632018768, 0.686080650535171, -0.466713890727058, 
    -0.0520955931471992, 0.736185103282417, 1.33396565224115, 
    0.63980493976393, 0.729477596903082, -0.428898034193583, 
    -0.0159324173319144, 0.594797632018768, 0.63980493976393, 
    1.34598399787709, 0.4810029673653, -0.568765736440115, -0.11263633925747, 
    0.686080650535171, 0.729477596903082, 0.4810029673653, 1.4950840880032
    ), dim = c(6L, 6L), dimnames = list(c("(Intercept)", "dsexFemale", 
    "b017451Once every few weeks", "b017451About once a week", 
    "b0174512 or 3 times a week", "b017451Every day"), c("(Intercept)", 
    "dsexFemale", "b017451Once every few weeks", "b017451About once a week", 
    "b0174512 or 3 times a week", "b017451Every day"))), rbar = 0.0857835117931858, 
    Ttilde = structure(c(1.10505906432044, -0.0585876782825894, 
    -0.744042521819899, -0.506750247276286, -0.465690413767903, 
    -0.617556458699585, -0.0585876782825894, 0.383593941331652, 
    -0.146494725392475, -0.056564536076315, -0.0172991560420006, 
    -0.122298679994505, -0.744042521819899, -0.146494725392475, 
    1.39440434327711, 0.799337646771812, 0.645821461699609, 0.744935058111432, 
    -0.506750247276286, -0.056564536076315, 0.799337646771812, 
    1.44839791050188, 0.694689654359507, 0.792054746939883, -0.465690413767903, 
    -0.0172991560420006, 0.645821461699609, 0.694689654359507, 
    1.46144723203242, 0.522265091088839, -0.617556458699585, 
    -0.122298679994505, 0.744935058111432, 0.792054746939883, 
    0.522265091088839, 1.62333765149823), dim = c(6L, 6L), dimnames = list(
        c("(Intercept)", "dsexFemale", "b017451Once every few weeks", 
        "b017451About once a week", "b0174512 or 3 times a week", 
        "b017451Every day"), c("(Intercept)", "dsexFemale", "b017451Once every few weeks", 
        "b017451About once a week", "b0174512 or 3 times a week", 
        "b017451Every day"))), waldDenomBaseDof = 63, n0 = 17606L, 
    nUsed = 16331L, Xstdev = list(outcome.std = 36.3450748753527, 
        `(Intercept)` = 0, dsexFemale = 0.500012547576328, `b017451Once every few weeks` = 0.392880957783438, 
        `b017451About once a week` = 0.380480563361107, `b0174512 or 3 times a week` = 0.403543023481001), 
    varSummary = list(structure(list(summary = structure(list(
        Variable = c("mrpcm1", "mrpcm2", "mrpcm3", "mrpcm4", 
        "mrpcm5"), N = c(16331, 16331, 16331, 16331, 16331), 
        Min. = c(130.53, 124.16, 115.09, 137.19, 123.58), `1st Qu.` = c(252.451666666667, 
        252.691666666667, 252.371666666667, 252.815, 252.86), 
        Median = c(277.5, 277.5, 277.47, 277.64, 277.33), Mean = c(276.139280509461, 
        275.92952544241, 275.934778029514, 276.016936501133, 
        275.980287796216), `3rd Qu.` = c(300.798333333333, 300.76, 
        300.678333333333, 300.828333333333, 300.61), Max. = c(410.8, 
        408.58, 398.17, 407.41, 395.96), SD = c(35.694086381693, 
        35.8508676252172, 35.9087308785062, 35.7219798072453, 
        35.8801154841422), `NA's` = c(0, 0, 0, 0, 0)), class = "data.frame", row.names = c(NA, 
    -5L))), class = "summary2"), structure(list(summary = structure(list(
        dsex = structure(1:2, levels = c("Male", "Female"), class = "factor"), 
        N = c(8163L, 8168L), Percent = c(49.9846916906497, 50.0153083093503
        )), row.names = c(NA, -2L), class = "data.frame")), class = "summary2"), 
        structure(list(summary = structure(list(b017451 = structure(1:5, levels = c("Never or hardly ever", 
        "Once every few weeks", "About once a week", "2 or 3 times a week", 
        "Every day"), class = "factor"), N = c(3837L, 3147L, 
        2853L, 3362L, 3132L), Percent = c(23.495193190864, 19.270099810177, 
        17.4698426305799, 20.5866144143041, 19.1782499540751)), row.names = c(NA, 
        -5L), class = "data.frame")), class = "summary2")))
