% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isWeight.R
\name{isWeight}
\alias{isWeight}
\title{Return a value indicating whether a variable is a weight on an edsurvey.data.frame or light.edsurvey.data.frame.}
\usage{
isWeight(var, sdf)
}
\arguments{
\item{var}{character indicating the variable in question.}

\item{sdf}{an \code{edsurvey.data.frame} or \code{light.edsurvey.data.frame}.}
}
\value{
A boolean (or vector when \code{var} is a vector) indicating if each element of \code{var}
        are weights.
}
\description{
For an \code{edsurvey.data.frame} or \code{light.edsurvey.data.frame}, return a value indicating whether a variable is a weight.
}
\details{
Note that this function returns TRUE only when \code{var} is the name of the weight used
        	for making estimates, not if the \code{var} is one of the individual jackknife replicates.
}
\examples{
# read in the example data (generated, not real student data)
sdf <- readNAEP(system.file("extdata/data", "M36NT2PM.dat", package = "NAEPprimer"))

# True
isWeight("origwt", sdf)

# False
isWeight("dsex", sdf)
}
\author{
Michael Lee and Paul Bailey
}
