% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eco.lagweight.R
\name{eco.lagweight}
\alias{eco.lagweight}
\title{Obtention of a list of spatial weights for classes
defined by inter-individual distances or nearest-neighbors}
\usage{
eco.lagweight(
  XY,
  int = NULL,
  smin = 0,
  smax = NULL,
  kmax = NULL,
  nclass = NULL,
  seqvec = NULL,
  size = NULL,
  bin = c("sturges", "FD"),
  cummulative = FALSE,
  row.sd = FALSE,
  self = FALSE,
  latlon = FALSE
)
}
\arguments{
\item{XY}{Matrix/data frame with projected coordinates.}

\item{int}{Distance interval in the units of XY.}

\item{smin}{Minimum class distance in the units of XY.}

\item{smax}{Maximum class distance in the units of XY.}

\item{kmax}{Number of nearest-neighbors.}

\item{nclass}{Number of classes.}

\item{seqvec}{Vector with breaks in the units of XY.}

\item{size}{Number of individuals per class.}

\item{bin}{Rule for constructing intervals when a partition parameter (int, 
nclass or size) is not given. Default is Sturge's rule (Sturges, 1926). Other
option is Freedman-Diaconis method (Freedman and Diaconis, 1981).}

\item{cummulative}{Logical. Should be created matrices considering cummulative
distances instead of discrete classes? Default FALSE.}

\item{row.sd}{Logical. Should be row standardized each matrix? Default FALSE 
(binary weights).}

\item{self}{Logical. Should be included a first matrix with ones in the diagonal and zeros
zeros in the other cells? Default FALSE.}

\item{latlon}{Are the coordinates in decimal degrees format? Defalut FALSE. If TRUE,
the coordinates must be in a matrix/data frame with the longitude in the first
column and latitude in the second. The position is projected onto a plane in
meters with the function \code{\link[SoDA]{geoXY}}.}
}
\value{
The program returns an object of class "eco.lagweight" with the following
slots:

> PAR parameters used for the construction of breaks

> PAR.VAL values of the parameters used for the construction of breaks

> ROW.SD row standardization (logical)

> SELF data self-included (logical)

> W weights list

> XY coordinates

> MEAN mean class distances

> LOGMEAN mean of the class distances logarithm

> CARDINAL number of elements in each class

> BREAKS breaks

> METHOD breaks construction method


\strong{ACCESS TO THE SLOTS}
The content of the slots can be accessed 
with the corresponding accessors, using
the generic notation of EcoGenetics 
(<ecoslot.> + <name of the slot> + <name of the object>).
See help("EcoGenetics accessors") and the Examples
section below.
}
\description{
This program returns a list of weights matrices (binary or
row-standardized), one for each spatial class. For a given maximum and minimum 
inter-individual distance (IID), the data can be partitioned in different ways. 
The program set as default the highest IID as the maximum, 
and the lowest as the minimum. 
These values can be changed with "smax" and "smin", respectively. 
Intervals may be generated with the parameters "int" (which divides the range 
each int distance units), "nclass" (which divides the range in n-classes) and "size" (a fixed
size of pairs included in each class). When a partition argument is not given (int, nclass or size) the program
determines the number of classes using the Sturge's rule (default) or 
the Freedman- Diaconis method. Two additional methods can be used:
a list with nearest-neighbors matrices, from 1 to k nearest-neighbors, may be generated
with the argument "kmax".
A custom vector with breaks may be provided by the user with the argument "seqvec".
See the examples.
}
\examples{
\dontrun{
data(eco.test)

# method sturges-smax: in this case, the program generates 
# classes using the Sturge's rule.  
# As smax and smin are undefined, the program uses the default
# options (smin = 0, and smax = maximum inter-individual distance)
classlist <- eco.lagweight(eco[["XY"]]) 
classlist

# method sturges-smax: idem, but smax = 16
classlist <- eco.lagweight(eco[["XY"]], smax=16) 

## using smax <16 in this case generates empty classes, 
## which is not allowed

# method sturges-smax: idem, but smin = 3
classlist <- eco.lagweight(eco[["XY"]], smin = 3, smax = 15)

# method sturges-smax: complete range, 
# and cummulative = TRUE (instead of using
# lower and upper limits for each class, only the upper is used in turn)
classlist <- eco.lagweight(eco[["XY"]], cummulative = TRUE)

# method n.classes-smax: complete range partitioned in 4 classes
classlist <- eco.lagweight(eco[["XY"]], nclass = 4)

# method n.classes-smax: idem, but smax =  15
classlist <- eco.lagweight(eco[["XY"]], nclass = 4, smax = 15)

# method int-smax: the complete range partitioned each <int> units
# of inter-individual distance
classlist <- eco.lagweight(eco[["XY"]], int = 2)

# method int-smax: idem, but smax = 15 and smin = 3
classlist <- eco.lagweight(eco[["XY"]], int = 2, smin = 3, smax = 15)

# method equal.size: n individuals in each class, 
# partitioning the complete range.
classlist <- eco.lagweight(eco[["XY"]], size = 1000)

## In the latter example, as an inter-individual distance
## appear more than one time (different individuals pairs, 
## identical distances), with a size <700 the limits
## of some classes cannot be defined, and this is not allowed

# method equal.size: n individuals in each class, 
# but smax = 15
classlist <- eco.lagweight(eco[["XY"]], size = 1000, smax = 15)

# method kmax: sequence from k = 1 to k = n, in this case, n = 3
classlist <- eco.lagweight(eco[["XY"]], kmax = 3)

# method kmax: idem, but elements self-included
# (i.e., the pairs i-i, for all individuals i, are included)
classlist <- eco.lagweight(eco[["XY"]], kmax = 3, self = TRUE)

# method seqvec: a vector with the breaks is used
vec <- seq(0, 10, 2)
classlist <- eco.lagweight(eco[["XY"]], seqvec = vec)

#-----------------------
# ACCESSORS USE EXAMPLE
#-----------------------

# the slots are accessed with the generic format 
# (ecoslot. + name of the slot + name of the object). 
# See help("EcoGenetics accessors")

ecoslot.BREAKS(classlist) # information about breaks. It includes the upper and lower limits

}

}
\references{
Freedman D., and P. Diaconis. 1981. On the histogram as a density estimator: 
L 2 theory. Probability theory and related fields, 57: 453-476.

Sturges  H. 1926. The choice of a class interval. Journal of the American 
Statistical Association, 21: 65-66.
}
\author{
Leandro Roser \email{learoser@gmail.com}
}
