% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eco.forestplot.R
\docType{methods}
\name{eco.forestplot}
\alias{eco.forestplot}
\alias{eco.forestplot,dataframeORmatrix-method}
\alias{eco.forestplot,eco.lsa-method}
\alias{eco.forestplot,generic-method}
\title{Forestplot graphs}
\usage{
eco.forestplot(input, xlabel = NULL, ylabel = NULL, titlelabel = NULL,
  legendlabel = NULL, ...)

\S4method{eco.forestplot}{eco.lsa}(input, rescaled = FALSE, xlabel, ylabel,
  titlelabel, legendlabel)

\S4method{eco.forestplot}{dataframeORmatrix}(input, xlabel, ylabel, titlelabel,
  legendlabel)
}
\arguments{
\item{input}{Matrix/data frame, with three columns in the 
folowing order: observed value, lower and upper values of the 
confidence interval.}

\item{xlabel}{Optional label for x axis.}

\item{ylabel}{Optional label for y axis.}

\item{titlelabel}{Optional title label.}

\item{legendlabel}{Optional legend label.}

\item{...}{Additional elements to the generic.}

\item{rescaled}{rescale values to [-1, 1] range?}
}
\description{
This program generates a forest plot 
for the confidence interval of each individual of the
input data (as row number)
and the corresponding observed value of the statistic.
}
\examples{
\dontrun{

require(ggplot2)
# simulated confidence intervals for the null hypotesis of a variable "a"
set.seed(8)
a<-runif(10, -2, 2)
infer <- runif(10, -1, 1)
super <- runif(10, -1, 1)
infer2 <- pmin(infer, super)
super2 <- pmax(infer, super)
data <- data.frame(a, infer2, super2)
forest <- eco.forestplot(data)
forest

# the forestplot method support the use of ggplot2 syntax
forest <- forest + theme_bw() + theme(legend.position="none")
forest
}


}
\author{
Leandro Roser \email{leandroroser@ege.fcen.uba.ar}
}

