% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EaseClass.R
\docType{class}
\name{Ease-class}
\alias{Ease-class}
\title{\code{Ease} class}
\description{
The \code{Ease} class is used to manage the simulations by handling the
objects needed to build the model. Thus to build an object of class
\code{Ease}, it is necessary to have defined an object \code{Genome},
as well as an object \code{MutationMatrix} and an object \code{Selection}
(even if it is neutral, see \link[Ease]{setSelectNeutral}).
}
\section{Slots}{

\describe{
\item{\code{N}}{the population size}

\item{\code{threshold}}{the maximum number of generations}

\item{\code{dioecy}}{logical indicating whether the simulated population is
dioecious or hermaphroditic}

\item{\code{selfRate}}{the selfing rate}

\item{\code{genome}}{a \code{Genome} object}

\item{\code{mutMat}}{a \code{MutationMatrix} object}

\item{\code{recMat}}{a two-by-two recombination rate vector}

\item{\code{meiosisMat}}{a meiosis matrix}

\item{\code{haploCrossMat}}{an haplotype crossing matrix}

\item{\code{haploCrossMatNamed}}{an haplotype crossing matrix with names of
genotypes instead of their indices}

\item{\code{gametogenesisMat}}{a gametogenesis matrix}

\item{\code{alleleFreqMat}}{a matrix for calculating allelic frequencies}

\item{\code{initGenoFreq}}{A row matrix of the size of the genotype number
describing the initial allele frequencies common to all simulations}

\item{\code{stopCondition}}{list of vectors that each describe the alleles that
must be fixed to define a stop condition. Each of these stop conditions
will therefore be associated with a stop condition}

\item{\code{IDstopCondition}}{IDs of stop conditions}

\item{\code{selection}}{a \code{Selection} object}

\item{\code{nsim}}{the number of simulation to perform}

\item{\code{results}}{a list of data.frames that describe the results of the
simulations}

\item{\code{records}}{a list of the records of the simulations}
}}

\author{
Ehouarn Le Faou
}
