% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summaryEPX.R
\name{summary.epx}
\alias{summary.epx}
\title{Summarising an "\code{epx}" object}
\usage{
\method{summary}{epx}(object, ...)
}
\arguments{
\item{object}{Object of class "\code{epx}" returned by \code{\link{epx}}.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
Prints a summary of the object returned by the phalanx-formation
algorithm \code{\link{epx}}.
}
\description{
\code{summary} method for class "\code{\link{epx}}".
}
\examples{
# Example with data(harvest)
\donttest{

## Phalanx-formation using a base classifier with 50 trees (default = 500)

set.seed(761)
model <- epx(x = harvest[, -4], y = harvest[, 4],
            classifier.args = list(ntree = 50))
summary(model)

## The summary agrees with
(model$PHALANXES)[[4]]
}
}
