% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/test.parameters.R
\name{test.parameters}
\alias{test.parameters}
\title{Function to evaluate influence of model parameters.}
\usage{
test.parameters(X, q, l = 0, c = 100, rotation = "Varimax",
  plot = FALSE, legend, progressbar = FALSE, multicore = FALSE, ...,
  pm = FALSE)
}
\arguments{
\item{X}{Numeric matrix with m samples (rows) and n variables (columns).}

\item{q}{Numeric vector of length two, specifying the minimum and maximum
number of end-members to be modelled.}

\item{l}{Numeric vector specifying the weight tranformation limit, i.e.
quantile; default is 0.}

\item{c}{Numeric scalar specifying the constant sum scaling parameter, e.g.
1, 100, 1000; default is 0.}

\item{rotation}{Character scalar, rotation type, default is "Varimax" (cf.
Dietze et al., 2012). One out of the rotations provided in GPArotation is
possible (cf. \code{\link{rotations}}).}

\item{plot}{Character scalar, optional graphical output of the results.
Specify which tested parameter will be plotted: "mEm" (mean absolute
row-wise error), "mEn" (mean absolute column-wise error), "mRm" (mean
relative row-wise error), "mRn" (mean relative column-wise error), "mRt"
(mean relative total error), "ol" (number of overlapping end-members). All
plots except "ol" are colour-coded bitmaps of q, l and the specified test
parameter and line-plots the specified parameter vs. q.}

\item{legend}{Character scalar, specifying legend position (cf.
\code{\link{legend}}).  If omitted, no legend will be plotted, default is no
legend.}

\item{progressbar}{Logical scalar, optionally show a progress bar, default
is \code{FALSE}. Only available if option \code{multicore} is not used.}

\item{multicore}{Logical scalar, optionally ditribute calculations to all
available cores of the computer, default is \code{TRUE}.}

\item{pm}{Logical scalar to enable pm.}

\item{\dots}{Additional arguments passed to the plot function. Since the
function returns two plots (except for plot option "ol"), additional
graphical parameters must be specified as vector with the first element for
the first plot and the second element for the second plot. If graphical
parameters are natively vectors (e.g. a sequence of colours), they must be
specified as matrices with each vector as a row. A legend can only be added
to the second plot. Colours only apply to the second plot as well. If
colours are specified, \code{colour} should be used instead of \code{col}.
See example section for further advice.}
}
\value{
A list with result objects \item{mEm}{Absolute row-wise model
error.} \item{mEn}{Absolute column-wise model error.} \item{mRm}{Mean
row-wise explained variance.} \item{mRn}{Mean column-wise explained
variance.} \item{mRt}{Mean total explained variance.} \item{ol}{Number of
overlapping end-member loadings.} \item{q.max}{Maximum number of meaningful
end-members.}
}
\description{
All possible combinations of number of end-members and weight transformation
limits are used to perform EMMA. The function returns matrices of absolute
and relative measures of individual model performance.
}
\details{
The mean total explained variance mRt may be used to define a maximum number
of meaningful end-members for subsequent modelling, e.g. as the number of
end-members, which reaches the first local mRt maximum.\cr\cr Overlapping is
defined as one end-member having its mode within the "area" of any other
end-member, which is genetically not explainable.\cr\cr Special
acknowledgements go to Christoph Burow for his efforts to implement the
multicore functionality to this function.
}
\examples{
## load example data set
data(X, envir = environment())

## truncate the data set for faster computation
X.trunc <- X[1:20,]

## define test parameters
q <- 2:8 # number of end-members
l <- seq(from = 0, to = 0.3, by = 0.1)

## test parameter influence and plot mean total explained variance
TP <- test.parameters(X = X.trunc, q = q, l = l, plot = "mRt",
                      legend = "bottomright", cex = 0.7,
                      multicore = FALSE,
                      colour = rgb((1:7) / 7, 0.9, 0.2, 1))

## show maximum number of end-members
TP$q.max
}
\author{
Michael Dietze, Elisabeth Dietze
}
\references{
Dietze E, Hartmann K, Diekmann B, IJmker J, Lehmkuhl F, Opitz S,
Stauch G, Wuennemann B, Borchers A. 2012. An end-member algorithm for
deciphering modern detrital processes from lake sediments of Lake Donggi
Cona, NE Tibetan Plateau, China. Sedimentary Geology 243-244: 169-180.
}
\seealso{
\code{\link{EMMA}}
}
\keyword{EMMA}

