% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_attributes.R
\name{get_attributes}
\alias{get_attributes}
\title{get_attributes}
\usage{
get_attributes(x, eml = x)
}
\arguments{
\item{x}{an "attributeList" element from EML}

\item{eml}{The full eml document, needed only if <references> outside of attributes must be resolved.}
}
\value{
a data frame whose rows are the attributes (names of each column in the data file)
and whose columns describe metadata about those attributes.  By default separate tables
are given for each type
}
\description{
get_attributes
}
\details{
EML metadata can use "references" elements which allow one attribute to use metadata
declared elsewhere in the document.  This function will automatically resolve these references
and thus infer the correct metadata.
}
\examples{
\donttest{ # runs > 5s

eml <- read_eml(system.file("xsd/test/eml-datasetWithAttributelevelMethods.xml", package = "EML"))
get_attributes( eml@dataset@dataTable[[1]]@attributeList )

}
}

