% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variant_SEM.R
\name{get_prior_SEM}
\alias{get_prior_SEM}
\title{Prior specification or prior sampling for SEM estimation.}
\usage{
get_prior_SEM(
  prior = NULL,
  n_pars = NULL,
  sample = TRUE,
  N = 1e+05,
  selection = "mu",
  design = NULL,
  Lambda_mat = NULL,
  B_mat = NULL,
  K_mat = NULL,
  G_mat = NULL,
  covariates = NULL
)
}
\arguments{
\item{prior}{A named list containing the prior mean on group-level mean (theta_mu_mean), variance of group-level mean (theta_mu_var),
variance of the loadings and G (lambda_var), variance of the latent regressions and (B_var), shape and rate prior on the factor variances (a_p and b_p),
and shape and rate prior on the residual variances (a_e and b_e)}

\item{n_pars}{Argument used by the sampler, best left NULL. In user case inferred from the design}

\item{sample}{Whether to sample from the prior. Default is TRUE. If not returns a prior list}

\item{N}{How many samples to draw from the prior, default 1e5}

\item{selection}{Which parameter type to select e.g. \code{alpha}}

\item{design}{The design obtained from \code{design}, required when map = TRUE}

\item{Lambda_mat}{The loadings constraint matrix}

\item{B_mat}{The latent regressions constraint matrix}

\item{K_mat}{The regression on the parameters by the included covariates}

\item{G_mat}{The regression on the latent factors by the included covariates}

\item{covariates}{The included covariates}
}
\value{
A list with a single entry of type of samples from the prior (if sample = TRUE) or else a prior object
}
\description{
Prior specification or prior sampling for SEM estimation.
}
