% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allGenerics.R, R/allMethods.R
\name{plotDataTemporalMap}
\alias{plotDataTemporalMap}
\alias{plotDataTemporalMap,DataTemporalMap-method}
\title{Data Temporal heatmap}
\usage{
plotDataTemporalMap(
  dataTemporalMap,
  absolute = FALSE,
  startValue = 1,
  endValue = ncol(dataTemporalMap@probabilityMap),
  startDate = min(dataTemporalMap@dates),
  endDate = max(dataTemporalMap@dates),
  sortingMethod = "frequency",
  colorPalette = "Spectral",
  mode = "heatmap"
)

\S4method{plotDataTemporalMap}{DataTemporalMap}(
  dataTemporalMap,
  absolute = FALSE,
  startValue = 1,
  endValue = ncol(dataTemporalMap@probabilityMap),
  startDate = min(dataTemporalMap@dates),
  endDate = max(dataTemporalMap@dates),
  sortingMethod = "frequency",
  colorPalette = "Spectral",
  mode = "heatmap"
)
}
\arguments{
\item{dataTemporalMap}{of class \code{DataTemporalMap}}

\item{absolute}{indicates if the heatmap frequency values are absolute or relative. 
By default \code{FALSE}.}

\item{startValue}{indicates the first value to display in the heatmap.
By default 1.}

\item{endValue}{indicates the last value to display in the heatmap.
By default the last value of the \code{DataTemporalMap} object.}

\item{startDate}{a Date object indicating the first date to be displayed in the heatmap. 
By default the first date of the \code{DataTemporalMap} object.}

\item{endDate}{a Date object indicating the last date to be displayed in the heatmap. 
By default the last date of the \code{DataTemporalMap} object.}

\item{sortingMethod}{the method to sort data in the Y axis of the heatmap from "frequency" and 
"alphabetical", with "frequency" as default.}

\item{colorPalette}{color palette to be used. The default "Spectral" palette shows a 
color temperature scheme from blue, through yellow, to red (see "Spectral" palette in
 RColorBrewer package). The four remaining options are better suited for those with 
 colorblindness, including "Viridis", "Magma", and their reversed versions 
 "Viridis-reversed" and "Magma-reversed" (see "Viridis" and "Magma" palettes in the
 Viridis package).}

\item{mode}{indicates the plot mode as a 'heatmap' (default) or 'series'.
The other config parameters for the heatmap plot also apply for the series plot.}
}
\value{
A plot object based on the \code{plotly} package.
}
\description{
Plots a Data Temporal heatmap from an \code{DataTemporalMap} object.
}
\examples{
load(system.file("extdata",
                 "variabilityDemoNHDSdiagcode1-phewascode.RData",
                  package="EHRtemporalVariability"))

p <- plotDataTemporalMap(dataTemporalMap =  probMaps[[1]],
                    colorPalette    = "Spectral",
                    startValue = 2,
                    endValue = 40)
p

p <- plotDataTemporalMap(dataTemporalMap =  probMaps[[1]],
                    colorPalette    = "Spectral",
                    startValue = 2,
                    endValue = 40,
                    mode = "series")
p

\dontrun{

# For additional and larger examples download the following .Rdata file:

gitHubUrl  <- 'http://github.com/'
gitHubPath <- 'hms-dbmi/EHRtemporalVariability-DataExamples/'
gitHubFile <- 'raw/master/variabilityDemoNHDS.RData'
inputFile  <-  paste0(gitHubUrl, gitHubPath, gitHubFile)

load(url(inputFile))
plotDataTemporalMap(probMaps$`diagcode1-phewascode`, startValue = 2, endValue = 40)
}
}
