% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modDemo.R
\name{run_Demo}
\alias{run_Demo}
\title{Run Demographic Data}
\usage{
run_Demo(demo.path, toexclude, demo.mod.list)
}
\arguments{
\item{demo.path}{filename of demographic file (CSV, RData, RDS) or data.frame}

\item{toexclude}{expression that should evaluate to a logical, indicating if
the observation should be excluded}

\item{demo.mod.list}{list of expressions, giving modifications to make}
}
\value{
list with two components
  \item{demo}{demographic data}
  \item{exclude}{vector of excluded visit IDs}
}
\description{
This module will load and modify demographic data.
}
\details{
See EHR Vignette for Structured Data.
}
\examples{
set.seed(2525)
dateSeq <- seq(as.Date('2019/01/01'), as.Date('2020/01/01'), by="day")
demo <- data.frame(mod_id_visit = 1:10,
                   weight.lbs = rnorm(10,160,20),
                   age = rnorm(10, 50, 10),
                   enroll.date = sample(dateSeq, 10))
tmpfile <- paste0(tempfile(), '.rds')
saveRDS(demo, file = tmpfile)

# exclusion functions
exclude_wt <- function(x) x < 150
exclude_age <- function(x) x > 60
ind.risk <- function(wt, age) wt>170 & age>55
exclude_enroll <- function(x) x < as.Date('2019/04/01')

# make demographic data that:
# (1) excludes ids with weight.lbs < 150, age > 60, or enroll.date before 2019/04/01
# (2) creates new 'highrisk' variable for subjects with weight.lbs>170 and age>55
out <- run_Demo(demo.path = tmpfile,
               toexclude = expression(
                 exclude_wt(weight.lbs)|exclude_age(age)|exclude_enroll(enroll.date)
               ),
               demo.mod.list = list(highrisk = expression(ind.risk(weight.lbs, age))))

out


}
