\name{EDISON.run}
\alias{EDISON.run}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{Wrapper function for starting an MCMC simulation
}
\description{
This function provides a wrapper for starting an MCMC simulation, using only the data 
and some basic options as input.}
\usage{                                                                      
EDISON.run(input, output.file = "EDISON.output", 

information.sharing = "poisson", num.iter = 10000, 

prior.params = NULL, options=NULL)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{input}{Input data. Either a filename pointing to an R data file containing the results of \code{\link{simulateNetwork}}, or a NumTimePoints by NumNodes matrix.
}
  \item{output.file}{Where to save the output of the MCMC simulation.
}
  \item{information.sharing}{Which information sharing prior to use: \code{'poisson'} for the Poisson prior (no information sharing), \code{'exp_hard'} or \code{'exp_soft'} for the exponential prior with hard or soft coupling among nodes, respectively, and \code{'bino_hard'} or \code{'bino_soft'} for the binomial prior with hard or soft coupling among nodes.
}
  \item{num.iter}{Number of iterations of the MCMC simulation.
}
  \item{prior.params}{Initial values of the hyperparameters of the information sharing priors.
}
  \item{options}{Settings for the MCMC simulation, as generated by \code{\link{defaultOptions}}.
}
}
\value{
Returns the results of the MCMC simulation, similar to \code{\link{runDBN}}.
}
\references{
For details on the model and MCMC simulation, see:

Dondelinger et al. (2012), "Non-homogeneous dynamic Bayesian networks with 
Bayesian regularization for inferring gene regulatory networks with gradually 
time-varying structure", Machine Learning.
}
\author{
Sophie Lebre
Frank Dondelinger}

%% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{
\code{\link{runDBN}}}
\examples{
# Generate random gene network and simulate data from it
dataset = simulateNetwork(l=25)

# Run MCMC simulation to infer networks and changepoint locations
# Uses default settings: Poisson prior and 1500 iterations
result.poisson = EDISON.run(dataset$sim_data, num.iter=500)

# Use the binomial information sharing prior with hard node coupling, and
# run for 5000 iterations

# NOT EXECUTED
#result.bino = EDISON.run(dataset$sim_data, 
#                information.sharing='bino_hard', num.iter=5000)
                        
# Set options to allow saving network and changepoint samples to file
options = defaultOptions()
options$save.file = TRUE

# NOT EXECUTED
# result.bino2 = EDISON.run(dataset$sim_data, 
#                  information.sharing='bino_hard',
#                  num.iter=5000, output.file='bino2.results',
#                  options=options)
}
