% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{lastnews_table}
\alias{lastnews_table}
\title{Get a table with the latest date for each patient}
\usage{
lastnews_table(
  except = NULL,
  with_ties = FALSE,
  numeric_id = TRUE,
  prefer = NULL,
  warn_if_future = TRUE
)
}
\arguments{
\item{except}{the datasets/columns that should not be searched. Example: a scheduled visit for which the patient may have died before attending should not be considered.}

\item{with_ties}{in case of tie, whether to return the first \code{origin} (FALSE) or all the origins that share this tie (TRUE).}

\item{numeric_id}{set to FALSE if the patient ID column is not numeric}

\item{prefer}{preferred origins in the event of a tie. Usually the followup table.}

\item{warn_if_future}{whether to show a warning about dates that are after the extraction date}
}
\value{
a dataframe
}
\description{
This function search for date columns in every tables and returns the latest date
for each patient with the variable it comes from. Useful in survival analysis to get
the right censoring time.
}
\examples{
tm = edc_example_plot()
load_list(tm)
lastnews_table()
lastnews_table(except="db3")
lastnews_table(except="db3$date9")
lastnews_table(prefer="db2") 
}
