% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/complexity.R
\name{complexity}
\alias{complexity}
\alias{complexity.default}
\alias{complexity.formula}
\title{Extract the complexity measures from datasets}
\usage{
complexity(...)

\method{complexity}{default}(x, y, type, groups = "all", ...)

\method{complexity}{formula}(formula, data, type, groups = "all", ...)
}
\arguments{
\item{...}{Not used.}

\item{x}{A data.frame contained only the input attributes.}

\item{y}{A response vector with one value for each row/component of x.}

\item{type}{The type of supervised problem: The \code{"class"} is used for 
classification tasks and \code{"regr"} for regression tasks.}

\item{groups}{A list of complexity measures groups or \code{"all"} to include
all of them.}

\item{formula}{A formula to define the output column.}

\item{data}{A data.frame dataset contained the input and output attributes.}
}
\value{
A numeric vector named by the requested complexity measures.
}
\description{
This function is responsable to extract the complexity measures from the 
classification and regression tasks. For such, they take into account the 
overlap between classes imposed by feature values, the separability and 
distribution of the data points and the value of structural measures based on
the representation of the dataset as a graph structure. To set specific 
parameters for each group, use the characterization function.
}
\details{
The following groups are allowed for this method:
 \describe{
   \item{"overlapping"}{The feature overlapping measures characterize how 
     informative the available features are to separate the classes See 
     \link{overlapping} for more details.}
   \item{"neighborhood"}{Neighborhood measures characterize the presence and 
     density of same or different classes in local neighborhoods. See 
     \link{neighborhood} for more details.}
   \item{"linearity"}{Linearity measures try to quantify whether the classes 
     can be linearly separated. See \link{linearity.class} or 
     \link{linearity.regr} for more details.}
   \item{"dimensionality"}{The dimensionality measures compute information on
     how smoothly the examples are distributed within the attributes. See 
     \link{dimensionality} for more details.}
   \item{"balance"}{Class balance measures take into account the numbers of 
     examples per class in the dataset. See \link{balance} for more details.}
   \item{"network"}{Network measures represent the dataset as a graph and 
     extract structural information from it. See \link{network} for more 
     details.}
   \item{"correlation"}{Capture the relationship of the feature values with 
     the outputs. See \link{correlation} for more details.}
   \item{"smoothness"}{Estimate the smoothness of the function that must be 
     fitted to the data. See \link{smoothness} for more details.}
 }
}
\examples{
## Extract all complexity measures for classification task
data(iris)
complexity(Species ~ ., iris, type="class")

## Extract all complexity measures for regression task
data(cars)
complexity(speed~., cars, type="regr")
}
\references{
Tin K Ho and Mitra Basu. (2002). Complexity measures of supervised 
   classification problems. IEEE Transactions on Pattern Analysis and Machine
   Intelligence, 24, 3, 289--300.

 Albert Orriols-Puig, Nuria Macia and Tin K Ho. (2010). Documentation for 
   the data complexity library in C++. Technical Report. La Salle - 
   Universitat Ramon Llull.

 Ana C Lorena and Aron I Maciel and Pericles B C Miranda and Ivan G Costa and
   Ricardo B C Prudencio. (2018). Data complexity meta-features for 
   regression problems. Machine Learning, 107, 1, 209--246.
}
