% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process_numeric.r
\name{process_ecotox_numerics}
\alias{process_ecotox_numerics}
\title{Process ECOTOX search results by converting \code{character} to \code{numeric} where relevant}
\usage{
process_ecotox_numerics(
  x,
  .fns = as_numeric_ecotox,
  ...,
  add_units = FALSE,
  .names = NULL
)
}
\arguments{
\item{x}{A \code{data.frame} obtained with \code{search_ecotox()}, for which the numerics need
to be processed.}

\item{.fns}{Function to convert \code{character} to \code{numeric}. By default \code{as_numeric_ecotox()}
is used which also sanitises the input. You can also use \code{as.numeric()} if you don't
want the sanitation step. You can also write a custom function.}

\item{...}{Arguments passed to \code{.fns}.}

\item{add_units}{A \code{logical} value. When set to \code{TRUE} corresponding units
are parsed with \code{as_unit_ecotox()} (if available) and added to the numeric value.}

\item{.names}{A 'glue' specification used to rename the numeric columns. By default
it is \code{"{.col}"}, which will overwrite existing text columns with numeric columns.
You can for instance add a suffix with \code{"{.col}_num"} if you want to
rename the resulting numeric columns.}
}
\value{
Returns a \code{data.frame} in which the columns containing numeric information
is converted from the character format from the database to actual numerics.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}} The function \code{search_ecotox()} returns fields
from the ECOTOX database as is. Many numeric values are stored in the database as
text. It is not uncommon that these text fields cannot be converted directly and need
some sanitising first. \code{process_ecotox_numerics()} takes a \code{data.frame} returned by
\code{search_ecotox()}, locates numeric columns, represented by text, sanitises the text
and converts them to numerics.
}
\examples{
if (check_ecotox_availability()) {
  df <- search_ecotox(
    list(
      latin_name    = list(
        terms          = c("Skeletonema", "Daphnia"),
        method         = "contains"
      ),
      chemical_name = list(
        terms          = "benzene",
        method         = "exact"
      )
    ), list_ecotox_fields("full"))

  df_num <-
    process_ecotox_numerics(df, add_units = TRUE, warn = FALSE)
}
}
\seealso{
Other ecotox-sanitisers: 
\code{\link{as_date_ecotox}()},
\code{\link{as_numeric_ecotox}()},
\code{\link{as_unit_ecotox}()},
\code{\link{mixed_to_single_unit}()},
\code{\link{process_ecotox_dates}()},
\code{\link{process_ecotox_units}()}
}
\author{
Pepijn de Vries
}
\concept{ecotox-sanitisers}
