% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/database_access.r
\name{check_ecotox_build}
\alias{check_ecotox_build}
\title{Check the locally build database for validity}
\usage{
check_ecotox_build(path = get_ecotox_path(), version, ...)
}
\arguments{
\item{path}{A \code{character} string with the path to the location of the local database (default is
\code{\link[=get_ecotox_path]{get_ecotox_path()}}).}

\item{version}{A \code{character} string referring to the release version of the database you wish to locate.
It should have the same format as the date in the EPA download link, which is month, day, year, separated by
underscores ("\%m_\%d_\%Y"). When missing, the most recent available copy is selected automatically.}

\item{...}{Arguments that are passed to \code{\link[RSQLite:SQLite]{dbConnect()}} method
or \code{\link[RSQLite:SQLite]{dbDisconnect()}} method.}
}
\value{
Returns an indicative logical value whether the database is not corrupted.
\code{TRUE} indicates the database is most likely OK. \code{FALSE} indicates that something might
be wrong. Additional messages (when \code{FALSE}) are included as attributes containing hints
on the outcoming of the tests. See also the 'details' section.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}} Performs some simple tests to check whether the
locally built database is not corrupted.
}
\details{
For now this function tests if all expected tables are present in the locally built
database. Note that in later release of the database some tables were added. Therefore
for older builds this function might return \code{FALSE} whereas it is actually just fine
(just out-dated).

Furthermore, this function tests if all tables contain one or more records. Obviously,
this is no guarantee that the database is valid, but it is a start.

More tests may be added in future releases.
}
\examples{
\dontrun{
check_ecotox_build()
}
}
\author{
Pepijn de Vries
}
