% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evaluate_control_chart.R
\name{plot_PMROC}
\alias{plot_PMROC}
\title{Evaluate and Visualize Control Charts by PM-ROC curves}
\usage{
plot_PMROC(evaluate_control_chart)
}
\arguments{
\item{evaluate_control_chart}{an object of class evaluate_control_chart. \cr
\code{evaluate_control_chart} is an output from 
\code{evaluate_control_chart_one_group} or 
\code{evaluate_control_chart_two_group}.}
}
\value{
No return value, called for drawing one PM-ROC plot.
}
\description{
Evaluate and Visualize Control Charts by PM-ROC curves
}
\examples{
pattern<-estimate_pattern_long_1d(
  data_matrix=data_example_long_1d$data_matrix_IC,
  time_matrix=data_example_long_1d$time_matrix_IC,
  nobs=data_example_long_1d$nobs_IC,
  design_interval=data_example_long_1d$design_interval,
  n_time_units=data_example_long_1d$n_time_units,
  estimation_method="meanvar",
  smoothing_method="local linear",
  bw_mean=0.1,
  bw_var=0.1)

chart_IC_output<-monitor_long_1d(
  data_example_long_1d$data_matrix_IC,
  data_example_long_1d$time_matrix_IC,
  data_example_long_1d$nobs_IC,
  pattern=pattern,side="upward",chart="CUSUM",
  method="standard",parameter=0.2)

chart_OC_output<-monitor_long_1d(
  data_example_long_1d$data_matrix_OC,
  data_example_long_1d$time_matrix_OC,
  data_example_long_1d$nobs_OC,
  pattern=pattern,side="upward",chart="CUSUM",
  method="standard",parameter=0.2)

output_evaluate<-evaluate_control_chart_two_groups(
  chart_matrix_IC=chart_IC_output$chart[1:50,],
  time_matrix_IC=data_example_long_1d$time_matrix_IC[1:50,],
  nobs_IC=data_example_long_1d$nobs_IC[1:50],
  starttime_IC=rep(0,50),
  endtime_IC=rep(1,50),
  chart_matrix_OC=chart_OC_output$chart[1:50,],
  time_matrix_OC=data_example_long_1d$time_matrix_OC[1:50,],
  nobs_OC=data_example_long_1d$nobs_OC[1:50],
  starttime_OC=rep(0,50),
  endtime_OC=rep(1,50),
  design_interval=data_example_long_1d$design_interval,
  n_time_units=data_example_long_1d$n_time_units,
  no_signal_action="maxtime")

plot_evaluation(output_evaluate)
plot_PMROC(output_evaluate)

}
