% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{DurgaPlot}
\alias{DurgaPlot}
\title{Group and effect size plotting in base R.}
\usage{
DurgaPlot(
  es,
  contrasts,
  group.dx = 0,
  group.colour = "Set2",
  points = TRUE,
  points.method = c("quasirandom", "pseudorandom", "smiley", "maxout", "frowney",
    "minout", "tukey", "tukeyDense", "jitter", "overplot"),
  points.spread = ifelse(points.method == "jitter", 0.1, 0.3),
  points.dx = group.dx,
  points.adjust = 1,
  points.params = list(),
  violin = isFALSE(box) && isFALSE(bar),
  violin.shape = c("left-half", "right-half", "full"),
  violin.fill = TRUE,
  violin.params = list(),
  violin.adj = 1.5,
  violin.width = 0.35,
  violin.trunc = TRUE,
  violin.dx = group.dx,
  box = FALSE,
  box.fill = TRUE,
  box.outline = TRUE,
  box.notch = FALSE,
  box.params = list(boxwex = 0.8, staplewex = 0.5, outwex = 0.5),
  box.dx = group.dx,
  bar = FALSE,
  bar.fill = TRUE,
  bar.width = 0.8,
  bar.dx = group.dx,
  ef.size = TRUE,
  ef.size.position = c("right", "below"),
  ef.size.violin = TRUE,
  ef.size.violin.fill = TRUE,
  ef.size.violin.shape = c("right-half", "left-half", "full"),
  ef.size.violin.trunc = TRUE,
  ef.size.pch = 17,
  ef.size.lty = 1,
  ef.size.lwd = 2,
  ef.size.ticks = NULL,
  ef.size.label = es$effect.name,
  ef.size.dx = 0,
  ef.size.adj.margin = TRUE,
  ef.size.top.pad = 2.5,
  ef.size.height = 0.35,
  ef.size.mean.line.dx = group.dx,
  ef.size.line.col = "grey50",
  ef.size.line.lty = ifelse(ef.size.position == "below", 3, 1),
  ef.size.line.lwd = 1,
  ef.size.params = list(),
  paired = es$paired.data,
  paired.lty = 1,
  paired.lwd = 1,
  central.tendency = isFALSE(box) && isFALSE(bar),
  central.tendency.type = c("mean", "median"),
  central.tendency.symbol = c("point", "segment"),
  central.tendency.width = violin.width,
  central.tendency.params = list(),
  central.tendency.dx = group.dx,
  error.bars = !isFALSE(central.tendency) || !isFALSE(bar),
  error.bars.type = c("CI", "SD", "SE"),
  error.bars.lty = 1,
  error.bars.lwd = 3,
  error.bars.cross.width = 0,
  x.axis = TRUE,
  x.axis.dx = group.dx,
  xlab = "",
  left.ylab = es$data.col.name,
  left.las = graphics::par("las"),
  add = FALSE,
  xlim,
  ylim,
  ...
)
}
\arguments{
\item{es}{Data returned from a call to \code{\link{DurgaDiff}}}

\item{contrasts}{Set of contrasts (i.e. group comparisons) to be plotted.
Defaults to contrasts passed to \code{\link{DurgaDiff}}, otherwise \code{".
- group1"} (where \code{group1} is the first group). See Details for more
information.}

\item{group.dx}{Used to shift group centres horizontally. E.g.,
\code{group.dx = c(0.1, -0.1)} will group into pairs. Individual components
can be shifted independently using the appropriate \code{*.dx} parameters.}

\item{group.colour}{Colours to use for each group. Either an
\code{\link{RColorBrewer}} palette name or a vector of colours.}

\item{points}{If not \code{FALSE}, points are plotted. If \code{TRUE}, points
are
displayed with a default colour (which is the group colour with 40%
transparency). You may specify a vector of colours; if length 1, all points
are drawn with the specified colour. If length is less than the number of
data points, points in each group are drawn with the appropriate colour
(extra colours are ignored). Otherwise, \code{points} should be a vector of
colours with a value for each data point.}

\item{points.method}{Method used to avoid overplotting points. Use
\code{"overplot"} to overplot points and \code{"jitter"} to add random
noise to each x-value. See \code{\link[vipor]{offsetX}} for remaining
methods.}

\item{points.spread}{Numeric value used to adjust the points scatter method
points horizontally (ignored if \code{points.method = "overplot"}).}

\item{points.dx}{Horizontal shift to be applied to points in each group.}

\item{points.adjust}{Adjust the bandwidth used to calculate kernel density
when drawing points. Smaller values mean a tighter fit.}

\item{points.params}{List of named parameters to pass on to
\code{\link[graphics]{points}}, e.g. \code{DurgaPlot(es, points = "black",
points.params = list(pch = 21, bg = as.numeric(factor(data$Sex)) + 1))}.}

\item{violin}{If not \code{FALSE}, violin plots are drawn. Violins
are simply probability density plots, with density on the x-axis
and value on the y-axis. If \code{TRUE}, violins are drawn in
default colours. Otherwise specifies the colour of the violin
borders.}

\item{violin.shape}{Desired violin shape - left-half only (\code{"left"}),
right-half only (\code{"right"}), or a full violin (\code{"full"}).}

\item{violin.fill}{Colour used to fill violins. Specify \code{FALSE} or
\code{NA} to leave violins unfilled.}

\item{violin.params}{Additional graphical parameters applied to drawing
violins. May include \code{density}, \code{angle}, \code{lty}, \code{lwd},
\code{lend} etc. Values are passed on to \code{\link[graphics]{polygon}};
see its help page for details.}

\item{violin.adj}{Value used to control violin plot smoothness by adjusting
the kernel density bandwidth. Higher values produce a smoother plot.
Passed unchanged as the \code{adjust} argument to the
\code{\link[stats]{density}} function.}

\item{violin.width}{Width of maximum violin horizontal extents, as a
proportion of the distance between groups.}

\item{violin.trunc}{Numeric value that specifies what vertical proportion of
the violin is truncated.}

\item{violin.dx}{Horizontal shift to be applied to each violin.}

\item{box}{If not \code{FALSE}, draw a box-and-whisker plot of the grouped
values.
Value may be a colour, in which case the box borders are plotted with the
colour(s). See \code{\link[graphics]{boxplot}}.}

\item{box.fill}{Colour used to fill the bodies of the box-and-whisker plot.
If FALSE or NA, bodies are not filled.}

\item{box.outline}{If FALSE, don't draw outliers with the box plot.}

\item{box.notch}{If TRUE, draws notches in the sides of the boxes. See
\code{\link[grDevices]{boxplot.stats}} for the calculations used.}

\item{box.params}{List with additional graphical parameters to control the
box
plot. See \code{\link[graphics]{bxp}} graphical parameters for a complete
list.}

\item{box.dx}{Horizontal shift to be applied to each box.}

\item{bar}{If not \code{FALSE}, draw a bar plot of the group means or
medians,
according to \code{central.tendency}. May be \code{TRUE} or a colour.}

\item{bar.fill}{Colour used to fill bars.}

\item{bar.width}{Width of bars.}

\item{bar.dx}{Horizontal shift to be applied to each bar.}

\item{ef.size}{If not \code{FALSE}, effect sizes are plotted. May be
\code{TRUE} or
a colour.}

\item{ef.size.position}{Effect sizes are plotted to the right of the main
plot if there is only one effect size to plot and \code{ef.size.position !=
"below"}. If the effect size is drawn to the right, you will need to
increase the size of the right margin before plotting (see
\code{\link[graphics:par]{par(mar = ...)}}).}

\item{ef.size.violin}{If not \code{FALSE}, boostrapped effect size estimates
are shown as a violin plot. May be a colour that is used for the violin
border and fill (unless \code{ef.size.violin.fill} is specified).}

\item{ef.size.violin.fill}{Colour used to fill effect size violins. Default
is a transparent version of \code{ef.size.violin}.}

\item{ef.size.violin.shape}{Shape of the effect size violin. One of
\code{"right-half"}, \code{"left-half"} or \code{"full"}.}

\item{ef.size.violin.trunc}{If \code{TRUE}, effect size violin is truncated
vertically so that it just covers the estimated effect size.}

\item{ef.size.pch}{Symbol to represent mean effect size.}

\item{ef.size.lty}{Line style for the effect size error bar.}

\item{ef.size.lwd}{Line weight for the effect size error bar.}

\item{ef.size.ticks}{Optional locations and labels for ticks on the effect
size y-axis. E.g. to interpret effect size using Cohen's default values,
specify \code{ef.size.ticks = c("Large negative effect" = -0.8, "Medium
negative effect" = -0.5, "Small negative effect" = -0.2, "No effect" = 0,
"Small positive effect" = 0.2, "Medium positive effect" = 0.5, "Large
positive effect" = 0.8)}}

\item{ef.size.label}{Label to display on y-axis for effect size.}

\item{ef.size.dx}{Horizontal shift to be applied to each contrast/effect
size. Unlike other \code{.dx} parameters, \code{ef.size.dx} is indexed by
contrast rather than group. When effect size is below the plot, the
\code{group.dx} for the group above the effect size is also added.}

\item{ef.size.adj.margin}{If TRUE (the default), the right margin (if ES is
right) or bottom margin (if ES is below) is automatically increased to make
room to display the effect size or axis annotations. The margins are
restored before control returns from \code{DurgaPlot}.}

\item{ef.size.top.pad}{Gap (in units of default character height scaled by
\code{cex}) between the bottom of the main plot region and the top of the
effect size plot region. Only applies when effect size is positioned below.}

\item{ef.size.height}{Height of the effect size plot region as a proportion
of the main plot region. Only applies when effect size is positioned below.}

\item{ef.size.mean.line.dx}{Horizontal shift to be applied to the start (i.e.
left end) of the group mean horizontal lines when effect size is on the
right.}

\item{ef.size.line.col}{Colour of horizontal effect-size lines that depict
group means if effect size is on the right, otherwise colour of line at y = 0.}

\item{ef.size.line.lty}{Line style of horizontal effect-size lines.}

\item{ef.size.line.lwd}{Line width of horizontal effect-size lines.}

\item{ef.size.params}{List of graphical parameters to apply when drawing
effect
sizes. These parameters are passed to \code{\link[graphics]{par}} before
drawing the effect size. E.g. \code{ef.size.params = list(mgp = c(3.5, 1, 0))}
will shift the effect size y-axis label to the left or right (for
\code{ef.size.position} \code{"below"} or \code{"right"} respectively).
\code{ef.size.params = list(las = 1)} will rotate the effect size axis
labels without rotating the main axis labels.}

\item{paired}{If not \code{FALSE} and the data a paired, lines are drawn
joining the individual data points. May be \code{TRUE} or a colour.
Defaults to \code{TRUE} if the data are paired (i.e. the \code{id.col}
argument was specified in the call to \code{\link{DurgaDiff}}).}

\item{paired.lty}{Line style for pair lines.}

\item{paired.lwd}{Line width for pair lines.}

\item{central.tendency}{If not \code{FALSE}, a visual indicator of central
tendency
is drawn. May be \code{TRUE} or a colour, in which case it is used for mean/median and
error bars.}

\item{central.tendency.type}{Should the indicated measure of central tendency
be \code{"mean"} or \code{"median"}?}

\item{central.tendency.symbol}{Should central tendency be shown as a point or
a horizontal line segment?}

\item{central.tendency.width}{Width of the central tendency line segment.}

\item{central.tendency.params}{Additional arguments to be passed to
\code{\link[graphics]{points}} (if \code{central.tendency.symbol ==
"point"}) or \code{\link[graphics]{segments}} (if
\code{central.tendency.symbol == "segment"}).}

\item{central.tendency.dx}{Horizontal shift to apply to central tendency
indicator and error bars.}

\item{error.bars}{Should error bars be displayed? May be the colour to be
used for error bars.}

\item{error.bars.type}{Should error bars depict 95%% confidence intervals of
the mean (\code{"CI"}), standard deviation (\code{"SD"}) or standard error
(\code{"SE"})?}

\item{error.bars.lty}{Line style for error bars.}

\item{error.bars.lwd}{Line width for error bars.}

\item{error.bars.cross.width}{Length (in inches) of the horizontal crossbars
at the ends of the error bars. If 0, no crossbar is drawn.}

\item{x.axis}{if TRUE, display the x-axis ticks and labels.}

\item{x.axis.dx}{Horizontal shifts to be applied to each x-axis tick and
label.}

\item{xlab}{X axis label.}

\item{left.ylab}{Left-hand y-axis label.}

\item{left.las}{Orientation of axis labels on left-hand y-axis label (0 =
parallel to axis, 1 = horizontal).}

\item{add}{If TRUE, the effect size plot is added to the current plot. If
FALSE, a new plot is created.}

\item{xlim, ylim}{If specified, overrides the default plot extents.}

\item{...}{Additional arguments are passed on to the
\code{\link[graphics]{plot}} function.}
}
\value{
A list (returned invisibly) with 4 elements:

  \item{\code{es}}{Value of the \code{es} parameter.}
  \item{\code{extents}}{Matrix with the x-axis locations and y-axis extents
  of each displayed group.}
  \item{\code{plot.differences}}{A list of the
  displayed differences, as \code{DurgaGroupDiff} objects. Will be an empty
  list if no effect sizes are shown.}
  \item{\code{palette}}{Vector of colours used by default for each group.}
}
\description{
Plot grouped data and effect size in base R, with control over a large range
of possible display formats and options. To plot your data, first calculate
group differences by calling \code{\link{DurgaDiff}}, then pass the result to
\code{\link{DurgaPlot}}. Because there are so many parameters to this
function, they are prefixed according to the component they affect. Hence,
for example, all parameters that affect box plots are prefixed with
\code{box}.
}
\details{
Group data may be visualised in multiple ways: \code{points}, \code{violin},
\code{box} and \code{bar}. Each visualisation type is controlled by a set of
parameters with the same prefix. To display a type, for example box plots,
specify \code{box = TRUE}. Rather than \code{box = TRUE}, you may specify a
colour (e.g. \code{box \ "blue"}), which is used as the border/outline for
the boxes. You may also specify a vector of colours, one for each group. For
\code{points}, you may specify a colour for each individual point. When
colours are not specified, they default to the group colours
(\code{group.colour}).

Group data annotations are controlled with parameters \code{central.tendency}
and \code{error.bars}. \code{central.tendency} visually represents the mean
or median (\code{central.tendency.type}) of each group, while
\code{error.bars} are vertical bars showing the 95%% CI of the mean, standard
deviation or standard error of the groups (\code{error.bars.type}).

An effect size (for our purposes) is the difference in means between two
groups. Effect size display is controlled by \code{ef.size}. The set of
effect sizes (aka "contrasts") to be plotted is controlled by the
\code{contrasts} parameter. If a single effect size is displayed, it may be
positioned to the right of - or below - the main plot
(\code{ef.size.position}). If more than one effect size is displayed, it must
be below the main plot. If below, an effect size is drawn underneath its
primary group. See \code{\link{DurgaBrackets}} for a way to display multiple
effect sizes that would overlap if displayed as normal effect sizes.

Custom labels for individual effects can be specified as part of the
\code{contrasts} parameter. If \code{contrasts} is a named vector, the names
are used as contrast labels, e.g. \code{contrasts = c("Adult change" = "adult
- control", "Juvenile change" = "juvenile - control")}. A more flexible
(although more advanced) method is to assign the \code{label.plot} member of
a \code{DurgaDiff} object within \code{x}, see Examples for usage.

The \code{contrasts} parameter may be a single string, a vector of strings,
or a matrix. A single string has a format such as \code{"group1 - group2,
group3 - group4"}. A single asterisk, \code{"*"} creates contrasts for all
possible pairs of groups. A single string such as \code{".- control"}
compares all groups against the \code{"control"} group, i.e. the \code{"."}
expands to all groups except the named group. A vector of strings looks like
\code{c("group1 - group2", "group3 - group4")}. If a matrix is specified, it
must have a column for each contrast, with the first group in row 1 and the
second in row 2. See also the \code{contrasts} parameter to
\code{\link{DurgaDiff}}. It is an error to attempt to plot a contrast that
was not estimated by \code{\link{DurgaDiff}}.
}
\examples{

d <- DurgaDiff(petunia, "height", "group")
# Default plot
DurgaPlot(d)

# Boxplot with a single effect size plotted on the right
DurgaPlot(d, contrasts = "westerham_cross - self_fertilised",
          box = TRUE, points = "black", points.params = list(cex = 0.8))

# Use confidence brackets to show all group differences
p <- DurgaPlot(d, ef.size = FALSE, group.colour = "Set1",
          points = "black", points.method = "jitter",
          points.params = list(pch = 21), points.dx = 0.15,
          violin.dx = -0.05, violin = "black", violin.adj = 0.5,
          ylim = c(12, 75))
DurgaBrackets(p)

# Adjust group names, contrasts
d <- DurgaDiff(petunia, 1, 2,
               groups = c("self-fertilised" = "self_fertilised",
                          "intercrossed" = "inter_cross",
                          "Westerham-crossed" = "westerham_cross"),
               contrasts = c("Westerham-crossed - self-fertilised",
                             "Westerham-crossed - intercrossed",
                             "intercrossed - self-fertilised"))
# Shift the 2nd effect size horizontally (Westerham-crossed - intercrossed)
# so it doesn't overlap another
DurgaPlot(d, ef.size.dx = c(0, -2, 0))

# Custom difference labels with italics
d <- DurgaDiff(petunia, 1, 2)
d$group.differences[[3]]$label.plot <- expression(italic("sp. 2")~"-"~italic("sp. 1"))
d$group.differences[[2]]$label.plot <- expression(italic("sp. 3")~"-"~italic("sp. 1"))
DurgaPlot(d)

}
\references{
Gardner, M. J., & Altman, D. G. (1986). Confidence intervals rather than P
values: estimation rather than hypothesis testing. Br Med J (Clin Res Ed),
292(6522), 746-750. doi:10.1136/bmj.292.6522.746

Cumming, G. (2012). Understanding the new statistics : effect sizes,
confidence intervals, and meta-analysis (1st edition ed.). New York:
Routledge.
}
\seealso{
\code{\link{DurgaDiff}}, \code{\link{DurgaBrackets}},
  \code{\link{DurgaTransparent}}, \code{\link[vipor]{offsetX}}, \code{\link[graphics]{boxplot}},
  \code{\link[graphics]{bxp}}
}
