% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brackets.R
\name{DurgaBrackets}
\alias{DurgaBrackets}
\title{Annotate a \code{DurgaPlot} with confidence brackets}
\usage{
DurgaBrackets(
  plot.stats,
  contrasts,
  labels = "level CI",
  br.lwd = NULL,
  br.col = NULL,
  br.lty = 1,
  lb.col = NULL,
  lb.font = NULL,
  lb.cex = 1,
  snap.to = 1,
  shorten = 1.5,
  tip.length = 2,
  data.gap = 2.5,
  vertical.gap = 1.3,
  text.pad = 1.5,
  round.fn = function(x) signif(x, 2),
  ...
)
}
\arguments{
\item{plot.stats}{Object returned by the call to \code{\link{DurgaPlot}}}

\item{contrasts}{Set of contrasts (i.e. group comparisons) to be displayed as
brackets. Defaults to contrasts passed to \code{\link{DurgaDiff}}. Can be
specified as a character string (\code{"group 1 - group 2"}) or a list of
\code{DurgaDiff} objects. The bracket label always displays the effect size
for right-hand-group - left-hand-group, regardless of the order that groups
are specified in \code{contrasts}, i.e. \code{contrasts = "G1 - G2"} will
appear the same as \code{contrasts = "G2 - G1"}.}

\item{labels}{Text to display above each bracket. May be NULL, otherwise one
of: \code{"diff"} (displayed text is "\code{<difference in means>}"),
\code{"CI"} ("\code{[<lower>, <upper>]}"), \code{"level CI"} ("\code{<level>\% CI [<lower>,
<upper>]}") or \code{"diff CI"} ("\code{<difference in means> [<lower>,
<upper>]}"); a vector of texts to display for each element of \code{diffs},
or a function called with one argument; a \code{DurgaGroupDiff} object,
which should return the label to be displayed.}

\item{br.col, br.lwd, br.lty}{Graphical parameters (colour, line weight and
style) that control the bracket appearance - passed to
\code{\link[graphics]{segments}}. May be a single value or a vector with
one value per bracket. Refer to \code{Details} for default values.}

\item{lb.col, lb.cex, lb.font}{Graphical parameters (colour, scale and font)
that control the label appearance - passed to \code{\link[graphics]{text}}.
May be a single value or a vector with one value per bracket. Refer to
\code{Details} for default values.}

\item{snap.to}{Snaps the base of the lowest brackets onto horizontal grid
lines separated by \code{snap.to} mm. Used to improve aesthetics of
vertical alignment.}

\item{shorten}{Amount (mm) to shrink brackets at each end}

\item{tip.length}{Length of bracket tips (mm). May be a vector with length 2;
length of tip at groups 1 and 2 respectively}

\item{data.gap}{Vertical distance (mm) between top-most data point and bottom
of bracket}

\item{vertical.gap}{Vertical distance (mm) between overlapping brackets}

\item{text.pad}{Gap (mm) between bracket and text}

\item{round.fn}{By default, numbers displayed as text are printed to 2
significant figures. To change this behaviour, set \code{round.fn} to a
function with one argument that converts its argument to the value to be
displayed.}

\item{...}{Additional arguments passed to \code{\link[graphics]{text}}}
}
\value{
No return value. \code{DurgaBrackets} is called for its side effect
  of adding confidence brackets to the current plot.
}
\description{
Brackets are added to a \code{DurgaPlot} that already exists. That means you
must ensure there is sufficient space for the brackets above the plot. To do
this, either specify \code{ylim} to \code{\link{DurgaPlot}}, or create a
large top margin (\code{par(mar = c(...))}) and the turn off the plot frame
(\code{DurgaPlot(..., frame.plot = FALSE)}). In either case, experiment with
the values until the result is visually pleasing. The annotation can be drawn
into the margin as it will not be cropped.
}
\details{
Default values for \code{br.lwd}, \code{br.col}, \code{lb.col} and
\code{lb.font} depend on the confidence intervals (CI) being plotted. If the
CI covers 0, brackets and text are grey. If the CI does not cover 0, text is
dark grey and bold, and brackets are dark grey with a line width of 2.
}
\examples{

d <- DurgaDiff(petunia, 1, 2)
# Don't draw frame because brackets will appear in the upper margin
p <- DurgaPlot(d, ef.size = FALSE, frame.plot = FALSE)
# Add the brackets to the plot
DurgaBrackets(p, lb.cex = 0.8)

# Only draw brackets that do not include zero
p <- DurgaPlot(d, ef.size = FALSE, frame.plot = FALSE)
diffs <- Filter(function(pwes) (pwes$bca[4] > 0 || pwes$bca[5] < 0), d$group.differences)
DurgaBrackets(p, contrasts = diffs)

}
\seealso{
\code{\link{DurgaPlot}}
}
