% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/collections.R
\name{newCollection}
\alias{newCollection}
\title{Create or Extend a Collection}
\usage{
newCollection(
  drama,
  name = ifelse(inherits(drama, "QDDrama"), paste(unique(drama$meta$drama)),
    paste(drama, collapse = "_")),
  writeToFile = TRUE,
  dir = getOption("qd.collectionDirectory"),
  append = TRUE
)
}
\arguments{
\item{drama}{A text (or multiple texts, as data.frame or data.table), or a character 
vector containing the drama IDs to be collected}

\item{name}{The name of the collection and its filename (default = concatenated drama IDs)}

\item{writeToFile}{= Whether to write the collection to a file (default = TRUE)}

\item{dir}{The directory into which the collection file will be written (default = collection directory)}

\item{append}{Whether to extend the collection file if it already exists. 
If FALSE, the file will be overwritten. (default = TRUE)}
}
\value{
The function returns the ids that belong to the collection as a character vector.
}
\description{
\code{newCollection()} can be used to create new collections 
or add dramas to existing collection files.
}
\examples{
\donttest{
t <- combine(rksp.0, rjmw.0)
newCollection(t)
newCollection(c("rksp.0", "rjmw.0"), append=FALSE) # produces identical file
newCollection(c("a", "b"), name="rksp.0_rjmw.0") # adds "a" and "b" to the file
}
}
