% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_documentations.R
\docType{data}
\name{layers_example}
\alias{layers_example}
\title{Formatted layers object}
\format{
A list with 4 items. Each layer list contains 2 groups and a `name` element. Each group
contains `data` and `identifiers`. The structure for one individual layer:
\describe{
  \item{groupA}{Data associated with `groupA`}
  \describe{
  \item{data}{Raw data. Components (e.g. genes or proteins) in columns, samples in rows}
  \item{identifiers}{Data frame containing one column per ID}
  }
  \item{groupB}{Data associated with `groupB`}
  \describe{
  \item{data}{see above}
  \item{identifiers}{see above}
  }
  \item{name}{Name of the layer}
}
}
\source{
Terunuma, Atsushi et al. “MYC-driven accumulation of 2-hydroxyglutarate
is associated with breast cancer prognosis.” The Journal of clinical investigation
vol. 124,1 (2014): 398-412. doi:10.1172/JCI71180

Krug, Karsten et al. “Proteogenomic Landscape of Breast Cancer Tumorigenesis
and Targeted Therapy.” Cell vol. 183,5 (2020): 1436-1456.e31. doi:10.1016/j.cell.2020.10.036
}
\usage{
layers_example
}
\description{
Exemplary intermediate pipeline output containing a correctly formatted layers list.
}
\details{
List containing four layer items created by \code{\link[DrDimont]{make_layer}}.
Each layer contains `data` and `identifiers` stratified by group and a `name`
element giving the layer name. The data contained in this example refers to mRNA,
protein, phosphosite and metabolite layers. The mRNA, protein and phosphosite
data was adapted and reduced from Krug et al. (2020) containing data from the
Clinical Proteomic Tumor Analysis Consortium (CPTAC). The metabolite data was
sampled randomly to generate distributions similar to those reported, e.g., in
Terunuma et al. (2014). The `data` elements contain the raw data with samples as columns
and molecular entities as rows. The `identifiers` elements contain layer specific identifiers
for the molecular entities, e.g, gene_name.
}
\keyword{datasets}
