% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Sociogram.R
\name{Sociogram}
\alias{Sociogram}
\title{Social Network Graphs}
\usage{
Sociogram(data_sheet, bits, ...)
}
\arguments{
\item{data_sheet}{either a data.frame f.e imported from a data sheet
containing

"Name","item.number"

"action.from.","action.to","kind.of.action"

"name.of.action","action.number","classification","weighting"

or only "action.from.","action.to","kind.of.action"if exists actions and
items

data_sheet: with "action.from.","action.to","kind.of.action"

items with "Name","item.number"}

\item{bits}{as sting where each enabled action is set to 1 and each
disabled action is set to 0}

\item{...}{Postscript: FALSE (default) or path to PS output file

soziogram_layout:
layout.auto,layout.random,layout.circle,layout.sphere,layout.fruchterman.reingold,layout.kamada.kawai,layout.spring,layout.reingold.tilford,layout.fruchterman.reingold.grid,layout.lgl,layout.graphopt,layout.svd,layout.norm

curved: how much the lines between the nodes ar curved 0 ist stright,
default is 0.2

scal_value: the multiplicator of the nodes, default: 1/3

linesize_add: value to add to the linesize (helpful for a graph with thin
lines. default 0

log: log2 size of linewitdh, default= false

canvas.width: default 1000

canvas.height: default 800

tkplot: interactiv tkplot, default = true}
}
\value{
\item{sociogram}{ the igraph object} 
\item{counts_circles }{the count of cirles} 
\item{count_interactions }{the count of interactions}
\item{line_size}{the used linesize} 
\item{counts_circles }{vector of min #' and max line size} the last for are helpful to change circle size and #' linewidth
}
\description{
computes social network graphs with igraph
}
\examples{
{
## you can eihter use:
data_sheet=data.frame   ("action.from"=c(1,4,2,3,4,3,4,3,4,3,4,3,4,3,4),
                   "action.to"=c(4,1,1,4,3,4,3,4,3,4,3,4,3,4,3),
                   "kind.of.action"= c(4,1,1,4,3,4,3,4,3,4,3,4,3,4,3),stringsAsFactors=FALSE)
items= data.frame ("Name"=c("item1","item2","item3","item4","item5","item6") ,
                   "item.number"=c(1:6),stringsAsFactors=FALSE)
actions=data.frame("name.of.action"= c("leading","following","approach","bite","threat to bite",
                   "kick","threat to kick", "chase","retreat"),
                   "action.number"=c(1:9),
                   "classification"=c(1,2,1,1,1,1,1,1,2) ,
                   "weighting"=c(1,-1,1,1,1,1,1,1,-1),stringsAsFactors=FALSE)
## all  encounters  without leading and following
bytes= "001111111"  
Sociogram(data_sheet,items=items,actions=actions,bytes)
## mor you can use a complete f.e Excel sheet
## you can save this data as basic excel sheet to work with
data(data_Network_1)
## set 1 for action you want to show
bytes= "00111111111000000000"    
Sociogram(data_Network_1,bytes)
}
}
\author{
Knut Krueger, \email{Knut.Krueger@equine-science.de}
}
\keyword{~kwd1}
\keyword{~kwd2}
