% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_coreness.R
\name{get_coreness}
\alias{get_coreness}
\title{Get coreness values for graph nodes}
\usage{
get_coreness(graph, direction = "all")
}
\arguments{
\item{graph}{a graph object of class
\code{dgr_graph}.}

\item{direction}{using \code{all} (the default), the
search will ignore edge direction while traversing
through the graph. With \code{out}, measurements of
paths will be from a node whereas with \code{in},
measurements of paths will be to a node.}
}
\value{
a data frame with coreness values for
each of the nodes.
}
\description{
Get the coreness values for all nodes
in a graph.
}
\examples{
# Create a random graph using the
# `add_gnm_graph()` function
graph <-
  create_graph(
    directed = FALSE) \%>\%
  add_gnm_graph(
    n = 10,
    m = 15,
    set_seed = 23)

# Get coreness values for
# all nodes in the graph
graph \%>\%
  get_coreness()

# Add the coreness values
# to the graph as a node
# attribute
graph <-
  graph \%>\%
  join_node_attrs(
    df = get_coreness(.))

# Display the graph's node data frame
graph \%>\%
  get_node_df()
}
