% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_articulation_points.R
\name{get_articulation_points}
\alias{get_articulation_points}
\title{Get articulation points}
\usage{
get_articulation_points(graph)
}
\arguments{
\item{graph}{a graph object of class
\code{dgr_graph}.}
}
\value{
a vector of node IDs.
}
\description{
Get the nodes in the graph that are
identified as articulation points.
}
\examples{
# Create a random graph using the
# `add_gnm_graph()` function
graph <-
  create_graph() \%>\%
  add_gnm_graph(
    n = 10,
    m = 12,
    set_seed = 23) \%>\%
  set_node_attrs(
    node_attr = shape,
    values = "square")

# Get the articulation points
# in the graph (i.e., those
# nodes that if any were to be
# removed, the graph would
# become disconnected)
graph \%>\%
  get_articulation_points()

# For the articulation points,
# change the node shape to
# a `circle`
graph <-
  graph \%>\%
  select_nodes_by_id(
    nodes = get_articulation_points(.)) \%>\%
  set_node_attrs_ws(
    node_attr = shape,
    value = "circle")
}
