% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select_last_edges_created.R
\name{select_last_edges_created}
\alias{select_last_edges_created}
\title{Select the last set of edges created in a graph}
\usage{
select_last_edges_created(graph)
}
\arguments{
\item{graph}{a graph object of class
\code{dgr_graph}.}
}
\value{
a graph object of class \code{dgr_graph}.
}
\description{
Select the last edges that were created
in a graph object of class \code{dgr_graph}. This
function should ideally be used just after creating
the edges to be selected.
}
\examples{
# Create a graph and add a cycle and then
# a tree in 2 separate function calls
graph <-
  create_graph() \%>\%
  add_cycle(
    n = 3,
    rel = "a") \%>\%
  add_balanced_tree(
    k = 2, h = 2,
    rel = "b")

# Select the last edges created (all edges
# from the tree) and then set their edge
# color to be `red`
graph <-
  graph \%>\%
  select_last_edges_created() \%>\%
  set_edge_attrs_ws(
    edge_attr = color,
    value = "red") \%>\%
  clear_selection()

# Display the graph's internal edge
# data frame to verify the change
get_edge_df(graph)
#>   id from to rel color
#> 1  1    1  2   a  <NA>
#> 2  2    2  3   a  <NA>
#> 3  3    3  1   a  <NA>
#> 4  4    4  5   b   red
#> 5  5    4  6   b   red
#> 6  6    5  7   b   red
#> 7  7    5  8   b   red
#> 8  8    6  9   b   red
#> 9  9    6 10   b   red
}
