% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/series_info.R
\name{series_info}
\alias{series_info}
\title{Get information on a graph series}
\usage{
series_info(graph_series)
}
\arguments{
\item{graph_series}{a graph series object of type
\code{dgr_graph_1D}.}
}
\value{
a data frame containing information on the
graphs within the supplied graph series.
}
\description{
Obtain a data frame with information
on the graphs within a graph series.
}
\examples{
# Create three graphs
graph_1 <-
  create_graph() \%>\%
  add_n_nodes(n = 3) \%>\%
  add_edges_w_string(
    edges = "1->3 1->2 2->3")

graph_2 <-
  graph_1 \%>\%
  add_node() \%>\%
  add_edge(
    from = 4,
    to = 3)

graph_3 <-
  graph_2 \%>\%
  add_node() \%>\%
  add_edge(
    from = 5,
    to = 2)

# Create an empty graph series and add
# the graphs
series <-
  create_series() \%>\%
  add_to_series(
    graph_1,
    graph_series = .) \%>\%
  add_to_series(
    graph_2,
    graph_series = .) \%>\%
  add_to_series(
    graph_3,
    graph_series = .)

# Get information on the graphs in the series
series_info(series)
#>   graph name date_time   tz nodes edges directed
#> 1     1 <NA>      <NA> <NA>     3     3     TRUE
#> 2     2 <NA>      <NA> <NA>     4     4     TRUE
#> 3     3 <NA>      <NA> <NA>     5     5     TRUE
}
