% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_graph_name.R
\name{get_graph_name}
\alias{get_graph_name}
\title{Get graph name}
\usage{
get_graph_name(graph)
}
\arguments{
\item{graph}{a graph object of class
\code{dgr_graph}.}
}
\value{
a single-length character vector with the
assigned graph name. If a graph name has not been
set, NA is returned.
}
\description{
Get the name of a graph object of class
\code{dgr_graph}.
}
\examples{
# Create an empty graph
graph <- create_graph()

# Provide the new graph with a name
graph <-
  set_graph_name(
    graph,
    name = "the_name")

# Get the graph's name
get_graph_name(graph)
#> [1] "the_name"
}
