% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_degree_histogram.R
\name{get_degree_histogram}
\alias{get_degree_histogram}
\title{Get histogram data for a graph's degree frequency}
\usage{
get_degree_histogram(graph, mode = "total")
}
\arguments{
\item{graph}{a graph object of class
\code{dgr_graph}.}

\item{mode}{using \code{total} (the default),
degree considered for each node will be the total
degree. With \code{in} and \code{out} the degree
used will be the in-degree and out-degree,
respectively.}
}
\value{
a data frame with degree counts.
}
\description{
Get histogram data for a graph's
degree frequency. The bin width is set to 1 and
zero-value degrees are omitted from the output.
}
\examples{
# Create a random, directed graph with 18 nodes
# and 22 edges
graph <-
  create_random_graph(
    n = 18, m = 22,
    set_seed = 23)

# Get degree histogram data for the
# `random_graph` (reporting on total degree)
graph \%>\%
  get_degree_histogram(mode = "total")
#>   degree total_degree_hist
#> 1      0                 1
#> 2      1                 4
#> 3      2                 4
#> 4      3                 4
#> 5      4                 5
}
