% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_graph.R
\name{create_graph}
\alias{create_graph}
\title{Create a graph object}
\usage{
create_graph(nodes_df = NULL, edges_df = NULL, directed = TRUE,
  graph_name = NULL, attr_theme = "default", write_backups = FALSE)
}
\arguments{
\item{nodes_df}{an optional data frame containing,
at minimum, a column (called \code{nodes}) which
contains node IDs for the graph. Additional
columns (node attributes) can be included with
values for the named node attribute.}

\item{edges_df}{an optional data frame containing,
at minimum, two columns (called \code{from} and
\code{to}) where node IDs are provided. Additional
columns (edge attributes) can be included with
values for the named edge attribute.}

\item{directed}{with \code{TRUE} (the default) or
\code{FALSE}, either directed or undirected edge
operations will be generated, respectively.}

\item{graph_name}{an optional string for labeling
the graph object.}

\item{attr_theme}{the theme (i.e., collection of
\code{graph}, \code{node}, and \code{edge} global
graph attributes) to use for this graph. The default
theme is called \code{default}. If this is set to
\code{NULL} then no global graph attributes will
be applied to the graph upon creation.}

\item{write_backups}{an option to write incremental
backups of changing graph states to disk. If
\code{TRUE}, a subdirectory of the working directory
will be used to store \code{RDS} files. The
default value is \code{FALSE} so one has to opt in
to use this functionality.}
}
\value{
a graph object of class \code{dgr_graph}.
}
\description{
Generates a graph object with the
option to use node data frames (ndfs) and/or edge
data frames (edfs) to populate the initial graph.
}
\examples{
# With `create_graph()` we can simply create an
# empty graph (and add in nodes and edges later,
# with other functions)
graph <- create_graph()

# A graph can be created with nodes and
# without edges; this is usually done in 2 steps:
# 1. create a node data frame (ndf) using the
#    `create_node_df()` function
ndf <- create_node_df(n = 4)

# 2. create the graph object with `create_graph()`
#    and pass in the ndf to `nodes_df`
graph <- create_graph(nodes_df = ndf)

# Get information on the graph's nodes
node_info(graph)
#>   id type label deg indeg outdeg loops
#> 1  1 <NA>  <NA>   0     0      0     0
#> 2  2 <NA>  <NA>   0     0      0     0
#> 3  3 <NA>  <NA>   0     0      0     0
#> 4  4 <NA>  <NA>   0     0      0     0

# You can create a similar graph with just nodes but
# also provide a range of attributes for the nodes
# (e.g., types, labels, arbitrary 'values')
ndf <-
  create_node_df(
    n = 4,
    label = TRUE,
    type = c("type_1", "type_1",
             "type_5", "type_2"),
    shape = c("circle", "circle",
              "rectangle", "rectangle"),
    values = c(3.5, 2.6, 9.4, 2.7))

graph <- create_graph(nodes_df = ndf)

# Get information on the graph's internal node
# data frame (ndf)
get_node_df(graph)
#>   id   type label     shape values
#> 1  1 type_1     1    circle    3.5
#> 2  2 type_1     2    circle    2.6
#> 3  3 type_5     3 rectangle    9.4
#> 4  4 type_2     4 rectangle    2.7

# A graph can also be created by specifying both
# the nodes and edges; create an edge data frame
# (edf) using the `create_edge_df()` function:
edf <-
  create_edge_df(
    from = c(1, 2, 3),
    to = c(4, 3, 1),
    rel = "leading_to",
    values = c(7.3, 2.6, 8.3))

# 2. create the graph object with `create_graph()`
#    and pass in the ndf and edf
graph <-
  create_graph(
    nodes_df = ndf,
    edges_df = edf)

# Get information on the graph's internal edge
# data frame (edf)
get_edge_df(graph)
#>   id from to        rel values
#> 1  1    1  4 leading_to    7.3
#> 2  2    2  3 leading_to    2.6
#> 3  3    3  1 leading_to    8.3

# Get information on the graph's internal node
# data frame (ndf)
get_node_df(graph)
#>   id   type label     shape values
#> 1  1 type_1     1    circle    3.5
#> 2  2 type_1     2    circle    2.6
#> 3  3 type_5     3 rectangle    9.4
#> 4  4 type_2     4 rectangle    2.7
}
