% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export_graph.R
\name{export_graph}
\alias{export_graph}
\title{Export a graph to various file formats}
\usage{
export_graph(graph, file_name = NULL, file_type = NULL, width = NULL,
  height = NULL)
}
\arguments{
\item{graph}{a graph object of class
\code{dgr_graph}.}

\item{file_name}{the name of the exported file
(including it's extension).}

\item{file_type}{the type of file to be exported.
Options for graph files are: \code{png}, \code{pdf},
\code{svg}, and \code{ps}. Options for graph file
formats are: \code{gexf}.}

\item{width}{output width in pixels or \code{NULL}
for default. Only useful for export to image file
formats \code{png}, \code{pdf}, \code{svg}, and
\code{ps}.}

\item{height}{output height in pixels or \code{NULL}
for default. Only useful for export to image file
formats \code{png}, \code{pdf}, \code{svg}, and
\code{ps}.}
}
\description{
Export a graph to a variety of file
formats, including image formats such as PNG, PDF,
SVG, and PostScript, and graph file formats such
as GEXF.
}
\examples{
\dontrun{
library(DiagrammeRsvg)

# Create a node data frame (ndf)
ndf <-
  create_node_df(
    n = 4,
    type = c("a", "a", "z", "z"),
    label = TRUE,
    value = c(3.5, 2.6, 9.4, 2.7))

# Create an edge data frame (edf)
edf <-
  create_edge_df(
    from = c(1, 2, 3),
    to = c(4, 3, 1),
    rel = c("rel_a", "rel_z", "rel_a"))

# Create a graph with the ndf and edf
graph <-
  create_graph(
    nodes_df = ndf,
    edges_df = edf)

# Create a PDF file for the graph (`graph.pdf`)
graph \%>\% export_graph("graph.pdf")

# Create a PNG file for the graph (`mypng`)
graph \%>\%
export_graph(
  file_name = "mypng",
  file_type = "PNG")
}
}

