% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/node_count.R
\name{node_count}
\alias{node_count}
\title{Get count of all nodes or certain types of nodes}
\usage{
node_count(graph, type = FALSE)
}
\arguments{
\item{graph}{a graph object of class
\code{dgr_graph} that is created using
\code{create_graph}.}

\item{type}{either a logical value, where
\code{TRUE} provides a named vector of node count by
type and \code{FALSE} (the default) provides a total
count, or, a character vector of \code{type} values
to filter the node count.}
}
\value{
a numeric vector of single length.
}
\description{
From a graph object of class
\code{dgr_graph}, get a count of nodes in the graph
and optionally obtain a count of nodes by their type.
}
\examples{
# Create a node data frame
nodes <-
  create_nodes(
    nodes = LETTERS,
    label = TRUE,
    type = c(rep("a_to_g", 7),
             rep("h_to_p", 9),
             rep("q_to_x", 8),
             rep("y_and_z",2)))

# Create an edge data frame
edges <-
  create_edges(
    from = sample(LETTERS, replace = TRUE),
    to = sample(LETTERS, replace = TRUE),
    rel = "letter_to_letter")

# Create a graph
graph <-
  create_graph(nodes_df = nodes,
               edges_df = edges)

# Get counts of nodes grouped by the
# `type` attribute
node_count(graph, type = TRUE) # the default
#> a_to_g  h_to_p  q_to_x y_and_z
#>      7       9       8       2

# Get a total count of nodes with no grouping
node_count(graph, type = FALSE)
#> [1] 26

# Get a count of nodes of one or more
# specified types
node_count(graph, type = "a_to_g")
#> [1] 7

node_count(graph, type = c("a_to_g", "q_to_x"))
#> [1] 15
}

