% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cyclicNullR.R
\name{cyclicNullR}
\alias{cyclicNullR}
\title{Create a cyclic shift-based null distribution for one or two copy number matrices}
\usage{
cyclicNullR(X, Y = NULL, numPerms = 100, randomSeed = NULL)
}
\arguments{
\item{X}{a matrix or a data frame of copy number data. The rows and columns
of X correspond to genes and subjects, respectively.}

\item{Y}{a matrix or a data frame of copy number data. The rows and columns
of X correspond to genes and subjects, respectively. It is assumed that
the rows of X and Y are indexed by the same set of genes that appear in
genomic order.}

\item{numPerms}{the number of cyclic shifts used to create the null distribution.
Default = 1e2.}

\item{randomSeed}{a random seed.  Default = NULL.}
}
\value{
a matrix with two columns.  The first column, maxNull, is an empirical
permutation-based null distribution for the maximum difference of row means
of X - row means of Y based on cyclic shift permutations of the columns of each
matrix; the second column, minNull, is an empirical distribution of the minimum
difference of the row means of X - the row means of Y based on the same permutations.
If Y = NULL, the null distributions apply to the maximum and minimum row means of X.
}
\description{
Create a cyclic shift-based null distribution for one or two copy number matrices
}
\details{
This function iteratively calls \code{\link{cyclicShiftColR}} to create an empirical
permutation-based null distribution to assess the statistical significance of either
(i) the maximum and minimum difference row means of X - row means of Y, or (ii) the
maximum and minimum row means of X, depending on whether two or one copy number matrices
are being analyzed. The application of cyclic shift permutations to DNA copy number
matrices was originally described by Walter et al. (Bioinformatics, 2011;27(5):678–685).
}
\examples{
data(DiNAMIC.Duo)
output = cyclicNullR(X = pD[["X"]], Y = pD[["Y"]], numPerms = 25, randomSeed = NULL)

}
