% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DemographicTable.R
\name{DemographicTable}
\alias{DemographicTable}
\title{Create Demographic Table}
\usage{
DemographicTable(
  data,
  data.name = substitute(data),
  groups = NULL,
  keep_missing_group = TRUE,
  exclude = NULL,
  exclude_pattern,
  include,
  include_pattern,
  overall = TRUE,
  compare = TRUE,
  ...
)
}
\arguments{
\item{data}{a \link[base]{data.frame}}

\item{data.name}{\link[base]{character} scalar, or the argument call of \code{data}.
A user-friendly name of the input \code{data}.}

\item{groups}{\link[base]{character} scalar or vector,
the name(s) of sub-group(s) for which the summary statistics are to be provided.
Default \code{NULL} indicating no sub-groups.}

\item{keep_missing_group}{\link[base]{logical} scalar.
If \code{TRUE} (default), the subjects with missing \code{group}
are put into a new group (\code{'.missing'}).
if \code{FALSE}, these subjects are removed from group-wise summary statistics.}

\item{exclude}{\link[base]{character} vector,
the name(s) of variable(s) to be excluded.
Default \code{NULL} indicating no variable are to be excluded.}

\item{exclude_pattern}{(optional) \link[base]{character} scalar as
\link[base:regex]{regular expression},
the pattern of the names of the variable(s) to be excluded.}

\item{include}{\link[base]{character} vector,
the name(s) of variable(s) to be included.
Default \code{names(data)} indicating all variables are to be included.}

\item{include_pattern}{\link[base]{character} scalar as
\link[base:regex]{regular expression},
the pattern of the names of the variable(s) to be included.}

\item{overall}{\link[base]{logical} scalar.
If \code{TRUE} (default), a column of overall summary statistics will be provided.}

\item{compare}{\link[base]{logical} scalar.
If \code{TRUE} (default), comparisons between group(s) will be made.}

\item{...}{potential parameters}
}
\value{
\code{\link{DemographicTable}} returns an object of S3 class \code{'DemographicTable'},
which inherits from \link[base]{matrix}.
}
\description{
Create a demographic table with simple summary statistics, with optional comparison(s) over one or more groups.
}
\details{
A demographic table with simple summary statistics, with optional comparison(s) over one or more groups, is created.

\link[base:numeric]{Numeric} variables are summarized in means, standard deviations, medians, inter-quartile-ranges (IQR),
skewness, Shapiro-Wilk normality test and ranges.
If \code{group} is specified, they are compared using two-sample \code{\link[stats:t.test]{t}}-test,
\code{\link[stats:wilcox.test]{Wilcoxon / Mann-Whitney}} test, one-way \code{\link[stats:aov]{ANOVA}} and/or
\code{\link[stats:kruskal.test]{Kruskal-Wallis}} test.

\link[base]{logical} and \link[base]{factor} variables are summarized in counts and percentages.
If \code{group} is specified, they are compared using \code{\link[stats:prop.test]{chi-squared}} test
and/or \code{\link[stats:fisher.test]{Fisher exact}} test.
}
\examples{
DemographicTable(esoph)
DemographicTable(ToothGrowth, groups = 'supp')
DemographicTable(ToothGrowth, groups = 'supp', compare = FALSE)
DemographicTable(warpbreaks, groups = c('wool', 'tension'))
DemographicTable(mtcars, groups = c('vs', 'am'), include = c('mpg', 'cyl', 'disp'))

# with missing value
DemographicTable(airquality, groups = 'Month', exclude = 'Day')
DemographicTable(MASS::survey, groups = 'Smoke')
DemographicTable(MASS::survey, groups = 'Smoke', keep_missing_group = FALSE)
DemographicTable(MASS::survey, groups = 'Smoke', keep_missing_group = FALSE, useNA = 'always')

# write to Word file
library(flextable)
library(officer)
x = read_docx() |> body_add_flextable(value = as_flextable(DemographicTable(esoph)))
(out = file.path(tempdir(), 'demostable.docx'))
print(x, target = out)
# system(paste('open', out)) # works on Mac & Windows, but requires Microsoft Word
file.remove(out)

}
