% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Stepwise.R
\name{stepwise_replacement}
\alias{stepwise_replacement}
\title{implementation of the decomposition algorithm of stepwise replacement}
\usage{
stepwise_replacement(func, pars1, pars2, symmetrical = TRUE,
  direction = "up", ...)
}
\arguments{
\item{func}{A function specified by the user. This must be able to take the vectors \code{pars1} or 
\code{pars2} as its argument, and to return the value of the function, \code{y}, when evaluated for 
these rates. It may also have additional arguments, not to be decomposed.}

\item{pars1}{vector of covariates to be passed on as arguments to \code{func()}. Covariates
can be in any order, as long as \code{func()} knows what to do with them. \code{pars1} is for time 1 
(or population 1).}

\item{pars2}{is the same as \code{pars1} but for time/population 2.}

\item{symmetrical}{logical. default \code{TRUE} as recommended by authors. Shall we average the results of replacing 1 with 2 and 2 with 1?}

\item{direction}{character. One of \code{"up"}, \code{"down"}, or \code{"both"}. Default \code{"up"}, as recommended by authors.}

\item{\dots}{optional parameters to pass on to \code{func()}.}
}
\value{
a matrix of the variable effects that is organized in the same way as 
\code{pars1} and \code{pars2}.
}
\description{
This implements the algorithm described in Andreev et al (2002), with defaults set
to approximate their recommendations for replacement ordering and result averaging.
}
\details{
The \code{symmetrical} argument toggles whether or not we replace pars1 with pars2 (\code{FALSE}), 
or take the arithmetic average or replacement in both directions. \code{direction} refers to whether we go 
from the bottom up or top down, or take the arithmetic average of these when replacing vector elements. 
Although the total difference will always sum correctly, the calculated contribution from individual components 
can vary greatly depending on the order in general. Defaults are set to symmetrically replace from the bottom 
up, per the authors' suggestion.
}
\examples{
data(Mxc1)
data(Mxc2)
# we'll want to pass in these dimensions
dims  <- dim(Mxc1)
# we need parameters in vec form
Mxc1v <- c(Mxc1)
Mxc2v <- c(Mxc2)
B     <- stepwise_replacement(func = Mxc2e0abrvec, 
		pars1 = Mxc1v, pars2 = Mxc2v, dims = dims, 
		# authors' recommendations:
		symmetrical = TRUE, direction = "up")
dim(B) <- dims
# the output, B, is also a single vector. Each element corresponds 
# to the effect of changes in that particular covariate toward the 
# overall change in the function value. sum(B) should equal the
# original difference
(check1 <- Mxc2e0abr(Mxc2) - Mxc2e0abr(Mxc1))
(check2 <- sum(B))
\dontshow{
# de facto unit test. In this case the residual is very tiny,
# but if differences are very large and there are very many components,
# then the residual can be larger albeit trivial. In that case
# increase N and go make a coffee.
stopifnot(abs(check1 - check2) < .Machine$double.eps)
check3 <- Mxc2e0abrvec(Mxc2v, dims = dims)- Mxc2e0abrvec(Mxc1v, dims = dims)
stopifnot(abs(check3 - check2) < .Machine$double.eps)
}

# This package does not supply default plotting functions, but one 
# strategy might be the following:
\dontrun{
Age <- c(0, 1, seq(5, 85, by = 5))
matplot(Age, B, type = 'l', 
xlab = "Age", ylab = "Contrib to diff in e(0)", col = 1:6)
legend("bottomleft",lty=1:5,col=1:6, 
         legend = c("Neoplasms","Circulatory","Respiratory",
			     "Digestive","Acc/viol","Other"))
}
}
\references{
\insertRef{horiuchi2008decomposition}{DemoDecomp}
\insertRef{andreev2012excel}{DemoDecomp}
}
