/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.deducer.data;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import org.rosuda.JGR.editor.Editor;
import org.rosuda.JGR.toolkit.AboutDialog;
import org.rosuda.JGR.util.ErrorMsg;
import org.rosuda.REngine.REXPLogical;
import org.rosuda.deducer.Deducer;
import org.rosuda.deducer.data.DataViewer;
import org.rosuda.deducer.data.DataViewerTab;
import org.rosuda.deducer.data.ExScrollableTable;
import org.rosuda.deducer.data.ExTable;
import org.rosuda.deducer.data.RDataFrameVariableModel;
import org.rosuda.deducer.menu.FactorDialog;
import org.rosuda.deducer.toolkit.LoadData;
import org.rosuda.deducer.toolkit.SaveData;
import org.rosuda.ibase.Common;
import org.rosuda.ibase.toolkit.EzMenuSwing;

public class VariableView
extends DataViewerTab
implements ActionListener {
    protected String dataName;
    protected ExScrollableTable variableScrollPane;
    protected ExTable ex;
    protected JComboBox comboBox;

    public VariableView(String string) {
        this.init(string);
    }

    protected void init(String string) {
        this.dataName = string;
        this.comboBox = new JComboBox();
        this.comboBox.addItem("Character");
        this.comboBox.addItem("Factor");
        this.comboBox.addItem("Double");
        this.comboBox.addItem("Integer");
        this.comboBox.addItem("Logical");
        this.comboBox.addItem("Date");
        this.comboBox.addItem("Time");
        this.comboBox.addItem("Other");
        RDataFrameVariableModel rDataFrameVariableModel = new RDataFrameVariableModel(string);
        this.ex = new ExTable();
        this.ex.setModel(rDataFrameVariableModel);
        this.ex.getColumnModel().getColumn(1).setCellEditor(new DefaultCellEditor(this.comboBox));
        this.ex.getColumnModel().getColumn(0).setPreferredWidth(200);
        this.ex.getColumnModel().getColumn(1).setPreferredWidth(70);
        this.ex.getColumnModel().getColumn(2).setPreferredWidth(300);
        this.ex.setColumnSelectionAllowed(true);
        this.ex.setRowSelectionAllowed(true);
        this.ex.getTableHeader().removeMouseListener(this.ex.getColumnListener());
        this.ex.getTableHeader().setReorderingAllowed(false);
        this.ex.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                ExTable exTable = (ExTable)mouseEvent.getSource();
                if (exTable.getSelectedColumn() == 2) {
                    final int n = exTable.getSelectedRow();
                    final String string = (String)exTable.getModel().getValueAt(n, 0);
                    final String string2 = VariableView.this.dataName;
                    REXPLogical rEXPLogical = (REXPLogical)Deducer.timedEval("is.factor(" + string2 + "$" + string + ")");
                    if (rEXPLogical != null && rEXPLogical.isTRUE()[0]) {
                        new Thread(new Runnable(){

                            public void run() {
                                FactorDialog factorDialog = new FactorDialog(null, string2 + "[," + (n + 1) + "]");
                                factorDialog.setLocationRelativeTo((this).VariableView.this.ex);
                                factorDialog.setTitle("Factor Editor: " + string);
                                factorDialog.setVisible(true);
                            }
                        }).start();
                    }
                }
            }
        });
        this.variableScrollPane = new ExScrollableTable(this.ex);
        this.variableScrollPane.setRowNamesModel(rDataFrameVariableModel.new RDataFrameVariableModel.VariableNumberListModel());
        this.variableScrollPane.displayContextualMenu(false);
        this.setLayout(new BorderLayout());
        this.add(this.variableScrollPane);
    }

    public void setData(String string) {
        this.dataName = string;
        RDataFrameVariableModel rDataFrameVariableModel = new RDataFrameVariableModel(this.dataName);
        this.ex.setModel(rDataFrameVariableModel);
        this.ex.getColumnModel().getColumn(1).setCellEditor(new DefaultCellEditor(this.comboBox));
        this.ex.getColumnModel().getColumn(0).setPreferredWidth(200);
        this.ex.getColumnModel().getColumn(1).setPreferredWidth(50);
        this.ex.getColumnModel().getColumn(2).setPreferredWidth(300);
        this.variableScrollPane.setRowNamesModel(rDataFrameVariableModel.new RDataFrameVariableModel.VariableNumberListModel());
    }

    public void refresh() {
        boolean bl = ((RDataFrameVariableModel)this.variableScrollPane.getExTable().getModel()).refresh();
        if (bl) {
            this.variableScrollPane.getRowNamesModel().refresh();
            this.variableScrollPane.autoAdjustRowWidth();
        }
    }

    public JMenuBar generateMenuBar() {
        JFrame jFrame = new JFrame();
        String[] stringArray = new String[]{"+", "File", "@NNew Data", "newdata", "@LOpen Data", "loaddata", "@SSave Data", "Save Data", "-", "-", "@PPrint", "print", "~File.Quit", "+", "Edit", "@CCopy", "copy", "@XCut", "cut", "@VPaste", "paste", "-", "Remove Data from Workspace", "Clear Data", "~Window", "+", "Help", "R Help", "help", "~About", "0"};
        JMenuBar jMenuBar = EzMenuSwing.getEzMenu(jFrame, this, stringArray);
        if (!Common.isMac()) {
            EzMenuSwing.addMenuSeparator(jFrame, "Edit");
            EzMenuSwing.addJMenuItem(jFrame, "Help", "About", "about", this);
            for (int i = 0; i < jMenuBar.getMenuCount(); ++i) {
                if (!jMenuBar.getMenu(i).getText().equals("About")) continue;
                jMenuBar.remove(i);
                --i;
            }
        }
        return jFrame.getJMenuBar();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            String string = actionEvent.getActionCommand();
            if (string == "Open Data") {
                new LoadData();
            } else if (string == "Save Data") {
                new SaveData(this.dataName);
            } else if (string == "Clear Data") {
                if (this.dataName == null) {
                    JOptionPane.showMessageDialog(this, "Invalid selection: There is no data loaded.");
                    return;
                }
                int n = JOptionPane.showConfirmDialog(null, "Remove Data Frame " + this.dataName + " from environment?\n" + "Unsaved changes will be lost.", "Clear Data Frame", 0, 3);
                if (n == 1) {
                    return;
                }
                Deducer.threadedEval("rm(" + this.dataName + ")");
            } else if (string == "about") {
                new AboutDialog(null);
            } else if (string == "cut") {
                this.ex.cutSelection();
            } else if (string == "copy") {
                this.ex.copySelection();
            } else if (string == "paste") {
                this.ex.pasteSelection();
            } else if (string == "print") {
                try {
                    this.ex.print(JTable.PrintMode.NORMAL);
                }
                catch (Exception exception) {}
            } else if (string == "editor") {
                new Editor();
            } else if (string == "exit") {
                ((JFrame)this.getTopLevelAncestor()).dispose();
            } else if (string == "newdata") {
                String string2 = JOptionPane.showInputDialog("Data Name: ");
                if ((string2 = Deducer.getUniqueName(string2)) != null) {
                    Deducer.threadedEval(string2.trim() + "<-data.frame(Var1=NA)");
                }
            } else if (string == "loaddata") {
                LoadData loadData = new LoadData();
            } else if (string == "help") {
                Deducer.execute("help.start()");
            } else if (string == "table") {
                DataViewer dataViewer = new DataViewer();
                dataViewer.setLocationRelativeTo(null);
                dataViewer.setVisible(true);
            } else if (string == "save") {
                new SaveData(this.dataName);
            }
        }
        catch (Exception exception) {
            new ErrorMsg(exception);
        }
    }

    public void cleanUp() {
        ((RDataFrameVariableModel)this.ex.getModel()).removeCachedData();
    }
}

