/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua.border;

import ch.randelshofer.quaqua.QuaquaManager;
import ch.randelshofer.quaqua.QuaquaUtilities;
import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import javax.swing.UIManager;
import javax.swing.text.JTextComponent;

public abstract class AbstractFocusedPainter {
    private static final ConvolveOp edgeLeftOp = new ConvolveOp(new Kernel(3, 1, new float[]{1.0f, 0.0f, -1.0f}));
    private static final ConvolveOp edgeRightOp = new ConvolveOp(new Kernel(3, 1, new float[]{-1.0f, 0.0f, 1.0f}));
    private static final ConvolveOp edgeTopOp = new ConvolveOp(new Kernel(1, 3, new float[]{1.0f, 0.0f, -1.0f}));
    private static final ConvolveOp edgeBottomOp = new ConvolveOp(new Kernel(1, 3, new float[]{-1.0f, 0.0f, 1.0f}));
    private static float[] gaussian;
    private static ConvolveOp gaussianVOp;
    private static ConvolveOp gaussianHOp;

    public AbstractFocusedPainter() {
        AbstractFocusedPainter.initFilters();
    }

    private static void initFilters() {
        float sum = "true".equals(QuaquaManager.getProperty("apple.awt.graphics.UseQuartz", "false")) ? 0.9f : 0.65f;
        gaussian = AbstractFocusedPainter.gaussian(2.0f, 4.0f, sum);
        gaussianVOp = new ConvolveOp(new Kernel(1, gaussian.length, gaussian));
        gaussianHOp = new ConvolveOp(new Kernel(gaussian.length, 1, gaussian));
    }

    protected void paint(Component c, Graphics cgx, int x, int y, int width, int height) {
        boolean isEditable = c instanceof JTextComponent ? ((JTextComponent)c).isEditable() : true;
        if (QuaquaUtilities.isFocused(c) && isEditable) {
            Graphics2D cg = (Graphics2D)cgx;
            int slack = 2;
            BufferedImage borderImg = new BufferedImage(width + 2 * slack, height + 2 * slack, 3);
            BufferedImage focusImg = new BufferedImage(width + 2 * slack, height + 2 * slack, 3);
            Graphics2D bg = borderImg.createGraphics();
            this.doPaint(c, bg, slack, slack, width, height);
            cg.drawImage((Image)borderImg, x - slack, y - slack, c);
            AbstractFocusedPainter.paintFocusRing(borderImg, focusImg, cgx, x - slack, y - slack);
            bg.dispose();
        } else {
            this.doPaint(c, cgx, x, y, width, height);
        }
    }

    public static void paintFocusRing(BufferedImage borderImg, BufferedImage focusImg, Graphics cgx, int x, int y) {
        Graphics2D cg = (Graphics2D)cgx;
        Graphics2D fg = focusImg.createGraphics();
        fg.setComposite(AlphaComposite.SrcOver);
        fg.drawImage(borderImg, edgeLeftOp, 0, 0);
        fg.drawImage(borderImg, edgeRightOp, 0, 0);
        fg.drawImage(borderImg, edgeTopOp, 0, 0);
        fg.drawImage(borderImg, edgeBottomOp, 0, 0);
        fg.setComposite(AlphaComposite.SrcIn);
        fg.setColor(UIManager.getColor("Focus.color"));
        fg.fillRect(0, 0, borderImg.getWidth(), borderImg.getHeight());
        cg.drawImage(focusImg, gaussianHOp, x, y);
        cg.drawImage(focusImg, gaussianVOp, x, y);
        fg.dispose();
    }

    protected abstract void doPaint(Component var1, Graphics var2, int var3, int var4, int var5, int var6);

    private static float[] gaussian(float radius, float sigma, float sum) {
        int r = (int)Math.ceil(radius);
        float[] gaussian = new float[r * 2 + 1];
        float h = 1.0f;
        float c = r;
        float invs2sq = 1.0f / (2.0f * sigma * sigma);
        for (int i = 0; i < gaussian.length; ++i) {
            float x = i;
            gaussian[i] = (float)((double)h * Math.exp(-Math.pow(x - c, 2.0) * (double)invs2sq));
        }
        AbstractFocusedPainter.normalizeKernel(gaussian, sum);
        return gaussian;
    }

    private static float[] pyramid(float radius, float sum) {
        int r = (int)Math.ceil(radius);
        float[] pyramid = new float[r * 2 + 1];
        float c = r;
        for (int i = 0; i < pyramid.length; ++i) {
            float x = i;
            pyramid[i] = c - Math.abs(x - c);
        }
        AbstractFocusedPainter.normalizeKernel(pyramid, sum);
        return pyramid;
    }

    private static void normalizeKernel(float[] kernel, float sum) {
        int i;
        float total = 0.0f;
        for (i = 0; i < kernel.length; ++i) {
            total += kernel[i];
        }
        if ((double)Math.abs(total) > 1.0E-20) {
            total = sum / total;
            i = 0;
            while (i < kernel.length) {
                int n = i++;
                kernel[n] = kernel[n] * total;
            }
        }
    }
}

