% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_and_plot_functions.R
\name{combine_summary}
\alias{combine_summary}
\title{Combine PubMed and STRING Metrics}
\usage{
combine_summary(
  pubmed_search_results,
  string_results,
  file_directory = NULL,
  export_format = "csv",
  export = FALSE,
  threshold_percentage = 20
)
}
\arguments{
\item{pubmed_search_results}{Data frame with PubMed search results.}

\item{string_results}{Data frame with STRING metrics.}

\item{file_directory}{Directory for saving the output summary. Defaults to NULL.}

\item{export_format}{Format for export, either "csv", "tsv", or "excel".}

\item{export}{Logical indicating whether to export the summary. Defaults to FALSE.}

\item{threshold_percentage}{Percentage threshold for ranking (default is 20\%).}
}
\value{
A data frame with combined summary including connectivity, precedence, and category.
}
\description{
Combine PubMed search summary and STRING gene metrics.
}
\examples{
pubmed_data <- data.frame(Gene = c("Gene1", "Gene2"), PubMed_Rank = c(1, 2))
string_data <- data.frame(Gene = c("Gene1", "Gene2"), Connectivity_Rank = c(2, 1))
combined <- combine_summary(pubmed_data, string_data, export = FALSE)
print(combined)
}
