% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HelperFunctions.R
\name{extractQueryTimes}
\alias{extractQueryTimes}
\title{Extract query times from a \code{ParallelLogger} log file}
\usage{
extractQueryTimes(logFileName)
}
\arguments{
\item{logFileName}{Name of the \code{ParallelLogger} log file. Assumes the file was created using
the default file logger.}
}
\value{
A data frame with queries and their run times in milliseconds.
}
\description{
When using the \code{ParallelLogger} default file logger, and using \code{options(LOG_DATABASECONNECTOR_SQL = TRUE)},
\code{DatabaseConnector} will log all SQL sent to the server, and the time to get a response.

This function parses the log file, producing a data frame with time per query.
}
\examples{

connection <- connect(dbms = "sqlite", server = ":memory:")
logFile <- tempfile(fileext = ".log")
ParallelLogger::addDefaultFileLogger(fileName = logFile, name = "MY_LOGGER")
options(LOG_DATABASECONNECTOR_SQL = TRUE)

executeSql(connection, "CREATE TABLE test (x INT);")
querySql(connection, "SELECT * FROM test;")

extractQueryTimes(logFile)

ParallelLogger::unregisterLogger("MY_LOGGER")
unlink(logFile)
disconnect(connection)

}
