% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DBI.R
\name{dbListFields,DatabaseConnectorConnection,character-method}
\alias{dbListFields,DatabaseConnectorConnection,character-method}
\title{List field names of a remote table}
\usage{
\S4method{dbListFields}{DatabaseConnectorConnection,character}(conn, name, database = NULL, schema = NULL, ...)
}
\arguments{
\item{conn}{A \linkS4class{DBIConnection} object, as returned by
\code{\link[DBI:dbConnect]{dbConnect()}}.}

\item{name}{a character string with the name of the remote table.}

\item{database}{Name of the database.}

\item{schema}{Name of the schema.}

\item{...}{Other parameters passed on to methods.}
}
\value{
\code{dbListFields()}
returns a character vector
that enumerates all fields
in the table in the correct order.
This also works for temporary tables if supported by the database.
The returned names are suitable for quoting with \code{dbQuoteIdentifier()}.
If the table does not exist, an error is raised.
Invalid types for the \code{name} argument
(e.g., \code{character} of length not equal to one,
or numeric)
lead to an error.
An error is also raised when calling this method for a closed
or invalid connection.
}
\description{
List field names of a remote table
}
\seealso{
\code{\link[DBI:dbColumnInfo]{dbColumnInfo()}} to get the type of the fields.

Other DBIConnection generics: 
\code{\link[DBI]{DBIConnection-class}},
\code{\link[DBI]{dbAppendTable}()},
\code{\link[DBI]{dbCreateTable}()},
\code{\link[DBI]{dbDataType}()},
\code{\link[DBI]{dbDisconnect}()},
\code{\link[DBI]{dbExecute}()},
\code{\link[DBI]{dbExistsTable}()},
\code{\link[DBI]{dbGetException}()},
\code{\link[DBI]{dbGetInfo}()},
\code{\link[DBI]{dbGetQuery}()},
\code{\link[DBI]{dbIsReadOnly}()},
\code{\link[DBI]{dbIsValid}()},
\code{\link[DBI]{dbListObjects}()},
\code{\link[DBI]{dbListResults}()},
\code{\link[DBI]{dbListTables}()},
\code{\link[DBI]{dbReadTable}()},
\code{\link[DBI]{dbRemoveTable}()},
\code{\link[DBI]{dbSendQuery}()},
\code{\link[DBI]{dbSendStatement}()},
\code{\link[DBI]{dbWriteTable}()}
}
