% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_qq.r
\name{plot_qq}
\alias{plot_qq}
\title{Plot QQ plot}
\usage{
plot_qq(
  data,
  by = NULL,
  sampled_rows = nrow(data),
  geom_qq_args = list(),
  geom_qq_line_args = list(),
  title = NULL,
  ggtheme = theme_gray(),
  theme_config = list(),
  nrow = 3L,
  ncol = 3L,
  parallel = FALSE
)
}
\arguments{
\item{data}{input data}

\item{by}{feature name to be broken down by. If selecting a continuous feature, it will be grouped by 5 equal ranges, otherwise, all existing categories for a discrete feature. Default is \code{NULL}.}

\item{sampled_rows}{number of rows to sample if data has too many rows. Default is all rows, which means do not sample.}

\item{geom_qq_args}{a list of other arguments to \link{geom_qq}}

\item{geom_qq_line_args}{a list of other arguments to \link{geom_qq_line}}

\item{title}{plot title}

\item{ggtheme}{complete ggplot2 themes. Default is \link{theme_gray}.}

\item{theme_config}{a list of configurations to be passed to \link{theme}}

\item{nrow}{number of rows per page. Default is 3.}

\item{ncol}{number of columns per page. Default is 3.}

\item{parallel}{enable parallel? Default is \code{FALSE}.}
}
\value{
invisibly return the named list of ggplot objects
}
\description{
Plot quantile-quantile for each continuous feature
}
\examples{
plot_qq(iris)
plot_qq(iris, by = "Species", ncol = 2L)

plot_qq(
  data = airquality,
  geom_qq_args = list(na.rm = TRUE),
  geom_qq_line_args = list(na.rm = TRUE)
)
}
\keyword{plot_qq}
