% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dummify.r
\name{dummify}
\alias{dummify}
\title{Dummify discrete features to binary columns}
\usage{
dummify(data, maxcat = 50L)
}
\arguments{
\item{data}{input data}

\item{maxcat}{maximum categories allowed for each discrete feature. The default is 50.}
}
\value{
dummified dataset (discrete features only) preserving original features. However, column order might be different.
}
\description{
Data dummification is also known as one hot encoding or feature binarization. It turns each category to a distinct column with binary (numeric) values.
}
\note{
This is different from \link{model.matrix}, where the latter aims to create a full rank matrix for regression-like use cases. If your intention is to create a design matrix, use \link{model.matrix} instead.
}
\examples{
## Dummify iris dataset
str(dummify(iris))

## Dummify diamonds dataset ignoring features with more than 5 categories
data("diamonds", package = "ggplot2")
str(dummify(diamonds, maxcat = 5))
}
\keyword{dummify}
