% Generated by roxygen2 (4.0.1): do not edit by hand
\name{dMerge}
\alias{dMerge}
\title{Merges 2 data frames and report/drop/keeps only duplicates.}
\usage{
dMerge(data1, data2, Var, dropDups = TRUE, dupsOut = FALSE,
  fromLast = FALSE, all = FALSE, all.x = all, all.y = all,
  sort = TRUE, suffixes = c(".x", ".y"), incomparables = NULL)
}
\arguments{
\item{data1}{a data frame. The first data frame to merge.}

\item{data2}{a data frame. The second data frame to merge.}

\item{Var}{character vector containing the names of the variables merge by. See \code{\link{merge}}.}

\item{dropDups}{logical. Whether or not to drop duplicated rows based on \code{Var}. If \code{dropDups = FALSE} then it gives a count of the duplicated rows.}

\item{dupsOut}{logical. If \code{TRUE} then a data frame only containing duplicated values is returned and \code{dropDups} is ignored.}

\item{fromLast}{logical indicating if duplication should be considered from the reverse side. Only relevant if \code{dropDups = TRUE}.}

\item{all}{logical; all = L is shorthand for all.x = L and all.y = L, where L is either TRUE or FALSE.}

\item{all.x}{logical; if TRUE, then extra rows will be added to the output, one for each row in x that has no matching row in y. These rows will have NAs in those columns that are usually filled with values from y. The default is FALSE, so that only rows with data from both x and y are included in the output.}

\item{all.y}{logical; analogous to all.x.}

\item{sort}{logical. Should the result be sorted on the by columns?}

\item{suffixes}{a character vector of length 2 specifying the suffixes to be used for making unique the names of columns in the result which not used for merging (appearing in by etc).}

\item{incomparables}{values which cannot be matched. See \code{\link{match}}.}
}
\description{
\code{dMerge} merges 2 data frames and reports/drops/keeps only duplicates.
}
\seealso{
\code{\link{duplicated}}, \code{\link{merge}}
}

