% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{cens_data}
\alias{cens_data}
\title{Censor a survival dataset}
\usage{
cens_data(
  data,
  cens_method = "Time",
  cens_time = NULL,
  cens_IF = NULL,
  cens_events = NULL
)
}
\arguments{
\item{data}{A dataframe containing uncensored survival data with columns: \code{pseudo_time}, \code{rec_time}, and \code{time}}

\item{cens_method}{Censoring method: \code{"Time"} (default), \code{"Events"}, or \code{"IF"}}

\item{cens_time}{Time point for censoring (required if \code{cens_method = "Time"})}

\item{cens_IF}{Information fraction for censoring (required if \code{cens_method = "IF"})}

\item{cens_events}{Number of events for censoring (required if \code{cens_method = "Events"})}
}
\value{
A list containing:
\describe{
\item{data}{Censored dataframe with updated \code{status} and filtered rows}
\item{cens_events}{Number of events used for censoring (if applicable)}
\item{cens_time}{Time point used for censoring}
\item{sample_size}{Number of subjects remaining after censoring}
}
}
\description{
Applies administrative censoring to a survival dataset using one of three methods: fixed time, fixed number of events, or fixed information fraction. The input data must contain columns for pseudo survival time, recruitment time, and observed time.
}
\examples{
set.seed(123)
df <- data.frame(
  pseudo_time = rexp(20, rate = 0.1),
  rec_time = runif(20, 0, 12),
  time = rexp(20, rate = 0.1)
)
censored <- cens_data(df, cens_method = "Time", cens_time = 10)
str(censored)

}
